/* pmfont.c */
/* Copyright 1990 Humanities and Arts Computing Center */
/* may be used under terms of HACC software general public license */
/* see the file license for details */
/* usage: pmfont inputfile outputtag [skipto] */
/*        watch out! no errorchecking on i/o operations */
/* improvements to ridgeway@blackbox.hacc.washington.edu */

/* history: */
/* v. 0.8 released 12/03/1990 */
/* misc. earlier versions also known as CCLIB2MF and JIS2MF */
/* those were never PUBLICLY released */

#include <stdio.h>
#include <string.h>
#define CHARHT 24
#define CHARWD 24
#define BYTES_IN_ROW 3
/* to do a 16x16 we say instead CHARHT 16, CHARWD 16, BYTES_IN_ROW 2 */


/* the charblock structure is used for processing each character */
typedef struct {
               unsigned char column[CHARWD];
               } videorow;
typedef struct {
                videorow row[CHARHT];
               } charblock;

/* the JIS font is a naked 24x24 bitmap some 7000 chars deep */
typedef struct {
                unsigned char bitmap[CHARHT*BYTES_IN_ROW];
                } jischar;


/* globally accessible area */
charblock editchar;
jischar thischar;
/* global vars  and strings */
char outfilename[128],mffilename[128];
char cmdline[256];
char outfiletag[80];

/* functions */
jumpout() { exit(1); }

void copyright()
{
  puts("pmfont  24x24 font --> METAFONT code generator\n");
  puts("HUMANITIES AND ARTS COMPUTING CENTER, DR-10");
  puts("UNIVERSITY OF WASHINGTON, SEATTLE WA 98195 USA\n");
  puts("Copyright 1990 Humanities and Arts Computing Center\n");
  puts("This software may be used, modified, and redistributed free of any");
  puts("fee or royalty, provided that this copyright and 'free software' notice");
  puts("remains intact in any copies redistributed, and that you may charge no fee");
  puts("of any sort whatsoever without the written permission of the Humanities");
  puts("and Arts Computing Center.");
  return;
}


void makedisplay()
{
  int temp,mask,i,j,k,hold;
  for (i=0; i<CHARHT; i++) {
    for (j=0; j<BYTES_IN_ROW; j++) {
      temp=thischar.bitmap[(i*BYTES_IN_ROW)+j];
      mask=0x80;
      for (k=0; k<8; k++) {
        hold=temp & mask;
        if (hold==0) editchar.row[i].column[k+(8*j)]=0;
        else editchar.row[i].column[k+(8*j)]=1;
        mask=mask / 2;
      } /* endfor k */
    } /* endfor j */
  } /* endfor i */
  return;
}


main(int argc, char *argv[])
{
  FILE *f1,*f2;
  int done,ch,i,k,codeout,fontpart,skipcount,stepper;
  char quote,percent;
  skipcount=0;
  quote=34;
  percent=37;
  /* yes, yes! we are assuming the ASCII character set */
  if (argc < 3) {
      printf("\nUsage: pmfont inputfontfile outputfiletag  [skipto]\n");
      jumpout();
    }
  if (argc > 3) sscanf(argv[3],"%02x",&skipcount);
  copyright();
  f1 = fopen(argv[1],"rb");
  strcpy(outfiletag,argv[2]);
/* no error checking ---- this is quickest and dirtiest */
  fontpart=160;
  if (skipcount > (fontpart+1)) {
     /* skip to desired starting block if indicated */
     skipcount=skipcount-fontpart-1;
     fontpart=fontpart+skipcount;
     for (stepper=0; stepper < skipcount; stepper++) {
          for (ch=161; ch<255; ch++) {
             fread(&thischar,sizeof(jischar),1,f1);
          } 
     }
  }
while (!feof(f1)) {
   fontpart++;
   sprintf(outfilename,"%s%02x.mf",outfiletag,fontpart);
   sprintf(mffilename,"%s%02x",outfiletag,fontpart);
   printf("\nJIS2MF: attempting to open %s for output.\n",outfilename);
   f2 = fopen(outfilename,"w");
   fprintf(f2,"%c This is %s generated by pmfont.\n",percent,outfilename);
   fprintf(f2,"input poorman;\n");
   printf("Now processing character ");
   for (ch=161; ch<255; ch++) {
     /* generate code for character ch */
     fread(&thischar,sizeof(jischar),1,f1);
/* no error checking right? our last file may have a lot of garbage in it */
     /* actually this doesn't happen: but it could */
     printf("[%d] ",ch);
     fprintf(f2,"\njc(%d);\n",ch);
     makedisplay();
     codeout=0;
     for(i=0; i < CHARHT; i++) {
        for(k=0; k<CHARWD; k++) {
	    if (editchar.row[i].column[k] != 0) {
                fprintf(f2,"jd(%d,%d); ",i,k);
                codeout++;
                if (codeout > 4) {
                   fprintf(f2,"\n");
                   codeout=0;
                   }
                } /* endif set dot on */
        } /* end k */
        if (codeout > 0) {
           fprintf(f2,"\n");
           codeout=0;
	 }
     } /* endfor i */
     fprintf(f2,"enddef; endjc;\n");
     if ( ( ch % 16 ) == 0 ) printf("\n");
   } /* endfor ch */
   fprintf(f2,"\nbye.\n");
   fclose(f2); /* close this output file */
/* MakeFont should be a script file to call METAFONT to generate the font */
/* move the tfm and bitmap files to the right locations and delete the */
/* no longer needed .mf source code, .log files etc. */
/* the contents of MakeFont will be very system dependent */
   sprintf(cmdline,"%s %s%02x","MakeFont",outfiletag,fontpart);
   system(cmdline);
} /* end while not eof() on input file */   
   printf("\npmfont is done.  Good luck with your new fonts.\n");
   fclose(f2);
}

