/* Unit testing for outcomes
(C) 2013-2024 Niall Douglas <http://www.nedproductions.biz/> (1 commit)


Boost Software License - Version 1.0 - August 17th, 2003

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

#include <boost/outcome/outcome.hpp>

#include <boost/test/unit_test.hpp>
#include <boost/test/unit_test_monitor.hpp>

#pragma clang diagnostic ignored "-Wunneeded-internal-declaration"

namespace
{
  namespace outcome = BOOST_OUTCOME_V2_NAMESPACE;

  struct MovableError
  {
    MovableError() = default;
    MovableError(MovableError &&) = default;
    MovableError &operator=(MovableError &&) = default;
  };

  boost::system::error_code make_error_code(MovableError const &)
  {
    return {};
  }
  void outcome_throw_as_system_error_with_payload(MovableError) {}

  template <typename T> using MyResult = outcome::result<T, MovableError>;
}  // namespace

BOOST_OUTCOME_AUTO_TEST_CASE(issues_0291_test, "move of a non-const available void Result fails to compile")
{
  MyResult<int> f(outcome::success());
  MyResult<void> g(outcome::success());
  std::move(f).value();
  std::move(g).value();
}
