/*
 * Decompiled with CFR 0.152.
 */
package com.selectivem.collections;

import com.selectivem.collections.ImmutableCompactSubSet;
import com.selectivem.collections.IndexedImmutableSetImpl;
import com.selectivem.collections.UnmodifiableSetImpl;
import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class BitBackedSetImpl<E>
extends UnmodifiableSetImpl<E>
implements ImmutableCompactSubSet<E> {
    BitBackedSetImpl() {
    }

    static int bitArraySize(int size) {
        if (size <= 64) {
            return 1;
        }
        if (size <= 128) {
            return 2;
        }
        if (size <= 192) {
            return 3;
        }
        if (size <= 256) {
            return 4;
        }
        if ((size & 0x3F) == 0) {
            return size >> 6;
        }
        return size / 64 + 1;
    }

    static boolean setBit(long[] bits, int index, int bitArrayOffset) {
        if (index == -1) {
            return false;
        }
        int arrayIndex = (index >> 6) - bitArrayOffset;
        long bit = 1L << (index & 0x3F);
        if ((bits[arrayIndex] & bit) != 0L) {
            return false;
        }
        int n = arrayIndex;
        bits[n] = bits[n] | bit;
        return true;
    }

    static int lastNonZeroIndex(long[] array) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] == 0L) continue;
            return i;
        }
        return -1;
    }

    static int firstNonZeroIndex(long[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == 0L) continue;
            return i;
        }
        return -1;
    }

    static final class LongBacked<E>
    extends BitBackedSetImpl<E> {
        private final long bits;
        private final int size;
        private final IndexedImmutableSetImpl<E> elementToIndexMap;
        private final int bitArrayOffset;

        LongBacked(long bits, int size, IndexedImmutableSetImpl<E> elementToIndexMap, int bitArrayOffset) {
            this.bits = bits;
            this.size = size;
            this.elementToIndexMap = elementToIndexMap;
            this.bitArrayOffset = bitArrayOffset;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                int currentPosition;
                {
                    this.currentPosition = this.findNext(bitArrayOffset, 0);
                }

                @Override
                public boolean hasNext() {
                    return this.currentPosition != -1;
                }

                @Override
                public E next() {
                    if (this.currentPosition == -1) {
                        throw new NoSuchElementException();
                    }
                    Object result = elementToIndexMap.indexToElement(this.currentPosition);
                    this.currentPosition = this.findNext();
                    return result;
                }

                int findNext(int arrayIndex, int bitIndex) {
                    if (bitIndex >= 64) {
                        bitIndex = 0;
                        ++arrayIndex;
                    }
                    if (arrayIndex - bitArrayOffset > 0) {
                        return -1;
                    }
                    do {
                        long bit = 1L << bitIndex;
                        if ((bits & bit) != 0L) {
                            return arrayIndex << 6 | bitIndex;
                        }
                        if (++bitIndex < 64) continue;
                        bitIndex = 0;
                        ++arrayIndex;
                    } while (arrayIndex - bitArrayOffset <= 0);
                    return -1;
                }

                int findNext() {
                    int bitIndex = this.currentPosition & 0x3F;
                    int arrayIndex = this.currentPosition >> 6;
                    return this.findNext(arrayIndex, bitIndex + 1);
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean contains(Object o) {
            int index = this.elementToIndexMap.elementToIndex(o);
            if (index == -1) {
                return false;
            }
            long bit = 1L << (index & 0x3F);
            int arrayIndex = (index >> 6) - this.bitArrayOffset;
            if (arrayIndex != 0) {
                return false;
            }
            return (this.bits & bit) != 0L;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof LongBacked) {
                LongBacked other = (LongBacked)o;
                if (other.size != this.size) {
                    return false;
                }
                if (other.elementToIndexMap == this.elementToIndexMap) {
                    if (this.bitArrayOffset != other.bitArrayOffset) {
                        return false;
                    }
                    return this.bits == other.bits;
                }
                return super.equals(o);
            }
            return super.equals(o);
        }
    }

    static final class LongArrayBacked<E>
    extends BitBackedSetImpl<E> {
        private final long[] bits;
        private final int size;
        private final IndexedImmutableSetImpl<E> elementToIndexMap;
        private final int bitArrayOffset;

        LongArrayBacked(long[] bits, int size, IndexedImmutableSetImpl<E> elementToIndexMap, int bitArrayOffset) {
            this.bits = bits;
            this.size = size;
            this.elementToIndexMap = elementToIndexMap;
            this.bitArrayOffset = bitArrayOffset;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                int currentPosition;
                {
                    this.currentPosition = this.findNext(bitArrayOffset, 0);
                }

                @Override
                public boolean hasNext() {
                    return this.currentPosition != -1;
                }

                @Override
                public E next() {
                    if (this.currentPosition == -1) {
                        throw new NoSuchElementException();
                    }
                    Object result = elementToIndexMap.indexToElement(this.currentPosition);
                    this.currentPosition = this.findNext();
                    return result;
                }

                /*
                 * Unable to fully structure code
                 */
                int findNext(int arrayIndex, int bitIndex) {
                    actualArrayIndex = arrayIndex - LongArrayBacked.access$000(this);
                    if (bitIndex >= 64) {
                        bitIndex = 0;
                        ++arrayIndex;
                        if (++actualArrayIndex >= LongArrayBacked.access$200(this).length) {
                            return -1;
                        }
                        while (LongArrayBacked.access$200(this)[actualArrayIndex] == 0L) {
                            ++arrayIndex;
                            if (++actualArrayIndex < LongArrayBacked.access$200(this).length) continue;
                            return -1;
                        }
                    }
                    block1: while (true) {
                        bit = 1L << bitIndex;
                        if ((LongArrayBacked.access$200(this)[actualArrayIndex] & bit) != 0L) {
                            return arrayIndex << 6 | bitIndex;
                        }
                        if (++bitIndex < 64) continue;
                        bitIndex = 0;
                        ++arrayIndex;
                        if (++actualArrayIndex >= LongArrayBacked.access$200(this).length) {
                            return -1;
                        }
                        do {
                            if (LongArrayBacked.access$200(this)[actualArrayIndex] == 0L) ** break;
                            continue block1;
                            ++arrayIndex;
                        } while (++actualArrayIndex < LongArrayBacked.access$200(this).length);
                        break;
                    }
                    return -1;
                }

                int findNext() {
                    int bitIndex = this.currentPosition & 0x3F;
                    int arrayIndex = this.currentPosition >> 6;
                    return this.findNext(arrayIndex, bitIndex + 1);
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean contains(Object o) {
            int index = this.elementToIndexMap.elementToIndex(o);
            if (index == -1) {
                return false;
            }
            long bit = 1L << (index & 0x3F);
            int arrayIndex = (index >> 6) - this.bitArrayOffset;
            if (arrayIndex >= this.bits.length || arrayIndex < 0) {
                return false;
            }
            return (this.bits[arrayIndex] & bit) != 0L;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof LongArrayBacked) {
                LongArrayBacked other = (LongArrayBacked)o;
                if (other.size != this.size) {
                    return false;
                }
                if (other.elementToIndexMap == this.elementToIndexMap) {
                    if (this.bitArrayOffset != other.bitArrayOffset) {
                        return false;
                    }
                    if (this.bits.length != other.bits.length) {
                        return false;
                    }
                    for (int i = 0; i < this.bits.length; ++i) {
                        if (this.bits[i] == other.bits[i]) continue;
                        return false;
                    }
                    return true;
                }
                return super.equals(o);
            }
            return super.equals(o);
        }

        static /* synthetic */ long[] access$200(LongArrayBacked x0) {
            return x0.bits;
        }
    }
}

