/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.sketches.theta.HashIterator;
import com.yahoo.sketches.theta.PreambleUtil;

class MemoryHashIterator
implements HashIterator {
    private Memory mem;
    private int arrLongs;
    private long thetaLong;
    private long offsetBytes;
    private int index;
    private long hash;

    MemoryHashIterator(Memory mem, int arrLongs, long thetaLong) {
        this.mem = mem;
        this.arrLongs = arrLongs;
        this.thetaLong = thetaLong;
        this.offsetBytes = PreambleUtil.extractPreLongs(mem) << 3;
        this.index = -1;
        this.hash = 0L;
    }

    @Override
    public long get() {
        return this.hash;
    }

    @Override
    public boolean next() {
        while (++this.index < this.arrLongs) {
            this.hash = this.mem.getLong(this.offsetBytes + (long)(this.index << 3));
            if (this.hash == 0L || this.hash >= this.thetaLong) continue;
            return true;
        }
        return false;
    }
}

