/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.Objects;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.type.BindableType;
import org.hibernate.type.descriptor.java.JavaType;

public class ValueBindJpaCriteriaParameter<T>
extends JpaCriteriaParameter<T> {
    private final T value;

    public ValueBindJpaCriteriaParameter(BindableType<? super T> type, T value, NodeBuilder nodeBuilder) {
        super(null, type, false, nodeBuilder);
        SqmBindableType bindable;
        assert (value == null || type == null || (type instanceof SqmBindableType ? (bindable = (SqmBindableType)type).getExpressibleJavaType().isInstance(value) : type.getJavaType().isInstance(value)));
        this.value = value;
    }

    private ValueBindJpaCriteriaParameter(ValueBindJpaCriteriaParameter<T> original) {
        super(original);
        this.value = original.value;
    }

    @Override
    public ValueBindJpaCriteriaParameter<T> copy(SqmCopyContext context) {
        ValueBindJpaCriteriaParameter<T> existing = context.getCopy(this);
        return existing != null ? existing : context.registerCopy(this, new ValueBindJpaCriteriaParameter<T>(this));
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        SqmLiteral.appendHqlString(hql, this.getJavaTypeDescriptor(), this.value);
    }

    @Override
    public int compareTo(SqmParameter<T> parameter) {
        return Integer.compare(this.hashCode(), parameter.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ValueBindJpaCriteriaParameter) {
            ValueBindJpaCriteriaParameter that = (ValueBindJpaCriteriaParameter)obj;
            if (this.value == null) {
                return that.value == null && Objects.equals(this.getNodeType(), that.getNodeType());
            }
            JavaType<T> javaType = this.getJavaTypeDescriptor();
            if (that.value != null) {
                if (javaType != null) {
                    return javaType.equals(that.getJavaTypeDescriptor()) && javaType.areEqual(this.value, that.value);
                }
                return that.getJavaTypeDescriptor() == null && this.value.equals(that.value);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        JavaType<T> javaType = this.getJavaTypeDescriptor();
        return javaType == null ? this.value.hashCode() : javaType.extractHashCode(this.value);
    }
}

