/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.ListUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.oid4vci.CredentialScopeModel;
import org.keycloak.protocol.oid4vc.model.CredentialBuildConfig;
import org.keycloak.protocol.oid4vc.model.CredentialConfigId;
import org.keycloak.protocol.oid4vc.model.CredentialDefinition;
import org.keycloak.protocol.oid4vc.model.CredentialMetadata;
import org.keycloak.protocol.oid4vc.model.ProofTypesSupported;
import org.keycloak.protocol.oid4vc.model.VerifiableCredentialType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SupportedCredentialConfiguration {
    public static final String DOT_SEPARATOR = ".";
    @JsonIgnore
    private static final String FORMAT_KEY = "format";
    @JsonIgnore
    private static final String SCOPE_KEY = "scope";
    @JsonIgnore
    private static final String CRYPTOGRAPHIC_BINDING_METHODS_SUPPORTED_KEY = "cryptographic_binding_methods_supported";
    @JsonIgnore
    private static final String CREDENTIAL_SIGNING_ALG_VALUES_SUPPORTED_KEY = "credential_signing_alg_values_supported";
    @JsonIgnore
    private static final String PROOF_TYPES_SUPPORTED_KEY = "proof_types_supported";
    @JsonIgnore
    public static final String VERIFIABLE_CREDENTIAL_TYPE_KEY = "vct";
    @JsonIgnore
    private static final String CREDENTIAL_DEFINITION_KEY = "credential_definition";
    @JsonIgnore
    public static final String CREDENTIAL_BUILD_CONFIG_KEY = "credential_build_config";
    @JsonIgnore
    private static final String CREDENTIAL_METADATA_KEY = "credential_metadata";
    private String id;
    @JsonProperty(value="format")
    private String format;
    @JsonProperty(value="scope")
    private String scope;
    @JsonProperty(value="cryptographic_binding_methods_supported")
    private List<String> cryptographicBindingMethodsSupported;
    @JsonProperty(value="credential_signing_alg_values_supported")
    private List<String> credentialSigningAlgValuesSupported;
    @JsonProperty(value="vct")
    private String vct;
    @JsonProperty(value="credential_definition")
    private CredentialDefinition credentialDefinition;
    @JsonProperty(value="proof_types_supported")
    private ProofTypesSupported proofTypesSupported;
    @JsonProperty(value="credential_metadata")
    private CredentialMetadata credentialMetadata;
    @JsonIgnore
    private CredentialBuildConfig credentialBuildConfig;

    public static SupportedCredentialConfiguration parse(KeycloakSession keycloakSession, CredentialScopeModel credentialScope, List<String> globalSupportedSigningAlgorithms) {
        SupportedCredentialConfiguration credentialConfiguration = new SupportedCredentialConfiguration();
        String credentialConfigurationId = Optional.ofNullable(credentialScope.getCredentialConfigurationId()).orElse(credentialScope.getName());
        credentialConfiguration.setId(credentialConfigurationId);
        credentialConfiguration.setScope(credentialScope.getName());
        String format = Optional.ofNullable(credentialScope.getFormat()).orElse("dc+sd-jwt");
        credentialConfiguration.setFormat(format);
        String vct = Optional.ofNullable(credentialScope.getVct()).orElse(credentialScope.getName());
        credentialConfiguration.setVct(vct);
        CredentialDefinition credentialDefinition = CredentialDefinition.parse(credentialScope);
        credentialConfiguration.setCredentialDefinition(credentialDefinition);
        ProofTypesSupported proofTypesSupported = ProofTypesSupported.parse(keycloakSession, globalSupportedSigningAlgorithms);
        credentialConfiguration.setProofTypesSupported(proofTypesSupported);
        List signingAlgsSupported = credentialScope.getSigningAlgsSupported();
        signingAlgsSupported = signingAlgsSupported.isEmpty() ? globalSupportedSigningAlgorithms : ListUtils.intersection(signingAlgsSupported, globalSupportedSigningAlgorithms);
        credentialConfiguration.setCredentialSigningAlgValuesSupported(signingAlgsSupported);
        String bindingMethodsSupported = "jwk";
        credentialConfiguration.setCryptographicBindingMethodsSupported(List.of(bindingMethodsSupported));
        CredentialMetadata credentialMetadata = CredentialMetadata.parse(keycloakSession, credentialScope);
        credentialConfiguration.setCredentialMetadata(credentialMetadata);
        CredentialBuildConfig credentialBuildConfig = CredentialBuildConfig.parse(keycloakSession, credentialConfiguration, credentialScope);
        credentialConfiguration.setCredentialBuildConfig(credentialBuildConfig);
        return credentialConfiguration;
    }

    public VerifiableCredentialType deriveType() {
        if (Objects.equals(this.format, "dc+sd-jwt")) {
            return VerifiableCredentialType.from(this.vct);
        }
        return null;
    }

    public CredentialConfigId deriveConfiId() {
        return CredentialConfigId.from(this.id);
    }

    public String getFormat() {
        return this.format;
    }

    public SupportedCredentialConfiguration setFormat(String format) {
        this.format = format;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public SupportedCredentialConfiguration setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public List<String> getCryptographicBindingMethodsSupported() {
        return this.cryptographicBindingMethodsSupported;
    }

    public SupportedCredentialConfiguration setCryptographicBindingMethodsSupported(List<String> cryptographicBindingMethodsSupported) {
        this.cryptographicBindingMethodsSupported = Collections.unmodifiableList(cryptographicBindingMethodsSupported);
        return this;
    }

    public String getId() {
        return this.id;
    }

    public SupportedCredentialConfiguration setId(String id) {
        this.id = id;
        return this;
    }

    public List<String> getCredentialSigningAlgValuesSupported() {
        return this.credentialSigningAlgValuesSupported;
    }

    public SupportedCredentialConfiguration setCredentialSigningAlgValuesSupported(List<String> credentialSigningAlgValuesSupported) {
        this.credentialSigningAlgValuesSupported = Collections.unmodifiableList(credentialSigningAlgValuesSupported);
        return this;
    }

    public String getVct() {
        return this.vct;
    }

    public SupportedCredentialConfiguration setVct(String vct) {
        this.vct = vct;
        return this;
    }

    public CredentialDefinition getCredentialDefinition() {
        return this.credentialDefinition;
    }

    public SupportedCredentialConfiguration setCredentialDefinition(CredentialDefinition credentialDefinition) {
        this.credentialDefinition = credentialDefinition;
        return this;
    }

    public ProofTypesSupported getProofTypesSupported() {
        return this.proofTypesSupported;
    }

    public SupportedCredentialConfiguration setProofTypesSupported(ProofTypesSupported proofTypesSupported) {
        this.proofTypesSupported = proofTypesSupported;
        return this;
    }

    public CredentialMetadata getCredentialMetadata() {
        return this.credentialMetadata;
    }

    public SupportedCredentialConfiguration setCredentialMetadata(CredentialMetadata credentialMetadata) {
        this.credentialMetadata = credentialMetadata;
        return this;
    }

    public CredentialBuildConfig getCredentialBuildConfig() {
        return this.credentialBuildConfig;
    }

    public SupportedCredentialConfiguration setCredentialBuildConfig(CredentialBuildConfig credentialBuildConfig) {
        this.credentialBuildConfig = credentialBuildConfig;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupportedCredentialConfiguration that = (SupportedCredentialConfiguration)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.format, that.format) && Objects.equals(this.scope, that.scope) && Objects.equals(this.cryptographicBindingMethodsSupported, that.cryptographicBindingMethodsSupported) && Objects.equals(this.credentialSigningAlgValuesSupported, that.credentialSigningAlgValuesSupported) && Objects.equals(this.vct, that.vct) && Objects.equals(this.credentialDefinition, that.credentialDefinition) && Objects.equals(this.proofTypesSupported, that.proofTypesSupported) && Objects.equals(this.credentialMetadata, that.credentialMetadata) && Objects.equals(this.credentialBuildConfig, that.credentialBuildConfig);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.format, this.scope, this.cryptographicBindingMethodsSupported, this.credentialSigningAlgValuesSupported, this.vct, this.credentialDefinition, this.proofTypesSupported, this.credentialMetadata, this.credentialBuildConfig);
    }
}

