/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Filter;
import org.hibernate.Internal;
import org.hibernate.UnknownProfileException;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.EffectiveEntityGraph;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.FilterImpl;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.loader.ast.spi.CascadingFetchProfile;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;

public class LoadQueryInfluencers
implements Serializable {
    private final SessionFactoryImplementor sessionFactory;
    private CascadingFetchProfile enabledCascadingFetchProfile;
    private @Nullable HashSet<String> enabledFetchProfileNames;
    private @Nullable TreeMap<String, Filter> enabledFilters;
    private boolean subselectFetchEnabled;
    private int batchSize = -1;
    private final EffectiveEntityGraph effectiveEntityGraph;
    private Boolean readOnly;

    public LoadQueryInfluencers(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.batchSize = sessionFactory.getSessionFactoryOptions().getDefaultBatchFetchSize();
        this.subselectFetchEnabled = sessionFactory.getSessionFactoryOptions().isSubselectFetchEnabled();
        this.effectiveEntityGraph = new EffectiveEntityGraph();
    }

    public LoadQueryInfluencers(SessionFactoryImplementor sessionFactory, SessionCreationOptions options) {
        this.sessionFactory = sessionFactory;
        this.batchSize = options.getDefaultBatchFetchSize();
        this.subselectFetchEnabled = options.isSubselectFetchEnabled();
        this.effectiveEntityGraph = new EffectiveEntityGraph();
        for (FilterDefinition filterDefinition : sessionFactory.getAutoEnabledFilters()) {
            FilterImpl filter = new FilterImpl(filterDefinition);
            if (this.enabledFilters == null) {
                this.enabledFilters = new TreeMap();
            }
            this.enabledFilters.put(filterDefinition.getFilterName(), filter);
        }
    }

    public EffectiveEntityGraph applyEntityGraph(@Nullable RootGraphImplementor<?> rootGraph, @Nullable GraphSemantic graphSemantic) {
        EffectiveEntityGraph effectiveEntityGraph = this.getEffectiveEntityGraph();
        if (graphSemantic != null) {
            if (rootGraph == null) {
                throw new IllegalArgumentException("Graph semantic specified, but no RootGraph was supplied");
            }
            effectiveEntityGraph.applyGraph(rootGraph, graphSemantic);
        }
        return effectiveEntityGraph;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T fromInternalFetchProfile(CascadingFetchProfile profile, Supplier<T> supplier) {
        CascadingFetchProfile previous = this.enabledCascadingFetchProfile;
        this.enabledCascadingFetchProfile = profile;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.enabledCascadingFetchProfile = previous;
        }
    }

    public CascadingFetchProfile getEnabledCascadingFetchProfile() {
        return this.enabledCascadingFetchProfile;
    }

    public boolean hasEnabledCascadingFetchProfile() {
        return this.enabledCascadingFetchProfile != null;
    }

    public void setEnabledCascadingFetchProfile(CascadingFetchProfile enabledCascadingFetchProfile) {
        this.enabledCascadingFetchProfile = enabledCascadingFetchProfile;
    }

    public boolean hasEnabledFilters() {
        return this.enabledFilters != null && !this.enabledFilters.isEmpty();
    }

    public Map<String, Filter> getEnabledFilters() {
        TreeMap<String, Filter> enabledFilters = this.enabledFilters;
        if (enabledFilters == null) {
            return Collections.emptyMap();
        }
        for (Filter filter : enabledFilters.values()) {
            filter.validate();
        }
        return enabledFilters;
    }

    public Set<String> getEnabledFilterNames() {
        return this.enabledFilters == null ? Collections.emptySet() : Collections.unmodifiableSet(this.enabledFilters.keySet());
    }

    public @Nullable Filter getEnabledFilter(String filterName) {
        return this.enabledFilters == null ? null : this.enabledFilters.get(filterName);
    }

    public Filter enableFilter(String filterName) {
        FilterImpl filter = new FilterImpl(this.sessionFactory.getFilterDefinition(filterName));
        if (this.enabledFilters == null) {
            this.enabledFilters = new TreeMap();
        }
        this.enabledFilters.put(filterName, filter);
        return filter;
    }

    public void disableFilter(String filterName) {
        if (this.enabledFilters != null) {
            this.enabledFilters.remove(filterName);
        }
    }

    public Object getFilterParameterValue(String filterParameterName) {
        String[] parsed = LoadQueryInfluencers.parseFilterParameterName(filterParameterName);
        if (this.enabledFilters == null) {
            throw new IllegalArgumentException("Filter [" + parsed[0] + "] currently not enabled");
        }
        FilterImpl filter = (FilterImpl)this.enabledFilters.get(parsed[0]);
        if (filter == null) {
            throw new IllegalArgumentException("Filter [" + parsed[0] + "] currently not enabled");
        }
        return filter.getParameter(parsed[1]);
    }

    public static String[] parseFilterParameterName(String filterParameterName) {
        int dot = filterParameterName.lastIndexOf(46);
        if (dot <= 0) {
            throw new IllegalArgumentException("Invalid filter-parameter name format [" + filterParameterName + "]; expecting {filter-name}.{param-name}");
        }
        String filterName = filterParameterName.substring(0, dot);
        String parameterName = filterParameterName.substring(dot + 1);
        return new String[]{filterName, parameterName};
    }

    public boolean hasEnabledFetchProfiles() {
        return this.enabledFetchProfileNames != null && !this.enabledFetchProfileNames.isEmpty();
    }

    public Set<String> getEnabledFetchProfileNames() {
        return this.enabledFetchProfileNames == null ? Collections.emptySet() : this.enabledFetchProfileNames;
    }

    private void checkFetchProfileName(String name) {
        if (!this.sessionFactory.containsFetchProfileDefinition(name)) {
            throw new UnknownProfileException(name);
        }
    }

    public boolean isFetchProfileEnabled(String name) throws UnknownProfileException {
        this.checkFetchProfileName(name);
        return this.enabledFetchProfileNames != null && this.enabledFetchProfileNames.contains(name);
    }

    public void enableFetchProfile(String name) throws UnknownProfileException {
        this.checkFetchProfileName(name);
        if (this.enabledFetchProfileNames == null) {
            this.enabledFetchProfileNames = new HashSet();
        }
        this.enabledFetchProfileNames.add(name);
    }

    public void disableFetchProfile(String name) throws UnknownProfileException {
        this.checkFetchProfileName(name);
        if (this.enabledFetchProfileNames != null) {
            this.enabledFetchProfileNames.remove(name);
        }
    }

    @Internal
    public @Nullable HashSet<String> adjustFetchProfiles(@Nullable Set<String> disabledFetchProfiles, @Nullable Set<String> enabledFetchProfiles) {
        HashSet<String> currentEnabledFetchProfileNames = this.enabledFetchProfileNames;
        HashSet<String> oldFetchProfiles = currentEnabledFetchProfileNames == null || currentEnabledFetchProfileNames.isEmpty() ? null : new HashSet<String>(currentEnabledFetchProfileNames);
        if (disabledFetchProfiles != null && this.enabledFetchProfileNames != null) {
            this.enabledFetchProfileNames.removeAll(disabledFetchProfiles);
        }
        if (enabledFetchProfiles != null) {
            if (this.enabledFetchProfileNames == null) {
                this.enabledFetchProfileNames = new HashSet();
            }
            this.enabledFetchProfileNames.addAll(enabledFetchProfiles);
        }
        return oldFetchProfiles;
    }

    @Internal
    public void setEnabledFetchProfileNames(HashSet<String> enabledFetchProfileNames) {
        this.enabledFetchProfileNames = enabledFetchProfileNames;
    }

    public EffectiveEntityGraph getEffectiveEntityGraph() {
        return this.effectiveEntityGraph;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int effectiveBatchSize(CollectionPersister persister) {
        int persisterBatchSize = persister.getBatchSize();
        return persisterBatchSize >= 0 ? persisterBatchSize : this.batchSize;
    }

    public boolean effectivelyBatchLoadable(CollectionPersister persister) {
        return persister.isBatchLoadable() || this.effectiveBatchSize(persister) > 1;
    }

    public int effectiveBatchSize(EntityPersister persister) {
        int persisterBatchSize = persister.getBatchSize();
        return persisterBatchSize >= 0 ? persisterBatchSize : this.batchSize;
    }

    public boolean effectivelyBatchLoadable(EntityPersister persister) {
        return persister.isBatchLoadable() || this.effectiveBatchSize(persister) > 1;
    }

    public boolean getSubselectFetchEnabled() {
        return this.subselectFetchEnabled;
    }

    public void setSubselectFetchEnabled(boolean subselectFetchEnabled) {
        this.subselectFetchEnabled = subselectFetchEnabled;
    }

    public boolean effectiveSubselectFetchEnabled(CollectionPersister persister) {
        return this.subselectFetchEnabled || persister.isSubselectLoadable() || this.isSubselectFetchEnabledInProfile(persister);
    }

    private boolean isSubselectFetchEnabledInProfile(CollectionPersister persister) {
        if (this.hasEnabledFetchProfiles()) {
            for (String profile : this.getEnabledFetchProfileNames()) {
                Fetch fetch;
                FetchProfile fetchProfile = persister.getFactory().getSqlTranslationEngine().getFetchProfile(profile);
                if (fetchProfile == null || (fetch = fetchProfile.getFetchByRole(persister.getRole())) == null || fetch.getMethod() != FetchStyle.SUBSELECT) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSubselectLoadableCollections(EntityPersister persister) {
        return persister.hasSubselectLoadableCollections() || this.subselectFetchEnabled && persister.hasCollections() || this.hasSubselectLoadableCollectionsEnabledInProfile(persister);
    }

    private boolean hasSubselectLoadableCollectionsEnabledInProfile(EntityPersister persister) {
        if (this.hasEnabledFetchProfiles()) {
            for (String profile : this.getEnabledFetchProfileNames()) {
                if (!persister.getFactory().getSqlTranslationEngine().getFetchProfile(profile).hasSubselectLoadableCollectionsEnabled(persister)) continue;
                return true;
            }
        }
        return false;
    }
}

