/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.unsafe;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.SegmentKt;
import kotlinx.io.UnsafeIoApi;
import kotlinx.io.unsafe.UnsafeBufferOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a9\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0087\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0001\u001aA\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0087\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0003 \u0001\u001az\u0010\f\u001a\u00020\r*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000f2>\u0010\u0005\u001a:\u0012\u001b\u0012\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000f\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\r0\u0010H\u0087\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0003 \u0001\u00a2\u0006\u0002\u0010\u0014\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0015"}, d2={"readFromHead", "", "Lkotlinx/io/unsafe/UnsafeBufferOperations;", "buffer", "Lkotlinx/io/Buffer;", "readAction", "Lkotlin/Function1;", "Ljava/nio/ByteBuffer;", "", "writeToTail", "minimumCapacity", "writeAction", "readBulk", "", "iovec", "", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "iovecSize", "(Lkotlinx/io/unsafe/UnsafeBufferOperations;Lkotlinx/io/Buffer;[Ljava/nio/ByteBuffer;Lkotlin/jvm/functions/Function2;)J", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nUnsafeBufferOperationsJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsafeBufferOperationsJvm.kt\nkotlinx/io/unsafe/UnsafeBufferOperationsJvmKt\n+ 2 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n99#2:187\n100#2,8:189\n195#2,28:197\n1#3:188\n*S KotlinDebug\n*F\n+ 1 UnsafeBufferOperationsJvm.kt\nkotlinx/io/unsafe/UnsafeBufferOperationsJvmKt\n*L\n50#1:187\n50#1:189,8\n100#1:197,28\n50#1:188\n*E\n"})
public final class UnsafeBufferOperationsJvmKt {
    /*
     * WARNING - void declaration
     */
    @UnsafeIoApi
    public static final int readFromHead(@NotNull UnsafeBufferOperations $this$readFromHead, @NotNull Buffer buffer, @NotNull Function1<? super ByteBuffer, Unit> readAction) {
        void limit;
        void pos;
        Intrinsics.checkNotNullParameter($this$readFromHead, "<this>");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(readAction, "readAction");
        boolean $i$f$readFromHead = false;
        UnsafeBufferOperations this_$iv = $this$readFromHead;
        boolean $i$f$readFromHead2 = false;
        if (!(!buffer.exhausted())) {
            boolean $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = false;
            String $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = "Buffer is empty";
            throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22.toString());
        }
        Segment segment = buffer.getHead();
        Intrinsics.checkNotNull(segment);
        Segment head$iv = segment;
        int n = head$iv.getLimit();
        int n2 = head$iv.getPos();
        byte[] rawData = head$iv.dataAsByteArray(true);
        boolean bl = false;
        ByteBuffer bb = ByteBuffer.wrap(rawData, (int)pos, (int)(limit - pos)).slice().asReadOnlyBuffer();
        Intrinsics.checkNotNull(bb);
        readAction.invoke(bb);
        int bytesRead$iv = bb.position();
        if (bytesRead$iv != 0) {
            if (bytesRead$iv < 0) {
                throw new IllegalStateException("Returned negative read bytes count");
            }
            if (bytesRead$iv > head$iv.getSize()) {
                throw new IllegalStateException("Returned too many bytes");
            }
            buffer.skip(bytesRead$iv);
        }
        return bytesRead$iv;
    }

    /*
     * WARNING - void declaration
     */
    @UnsafeIoApi
    public static final int writeToTail(@NotNull UnsafeBufferOperations $this$writeToTail, @NotNull Buffer buffer, int minimumCapacity, @NotNull Function1<? super ByteBuffer, Unit> writeAction2) {
        int n;
        void limit;
        void pos;
        Intrinsics.checkNotNullParameter($this$writeToTail, "<this>");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(writeAction2, "writeAction");
        boolean $i$f$writeToTail = false;
        UnsafeBufferOperations this_$iv = $this$writeToTail;
        boolean $i$f$writeToTail2 = false;
        Segment tail$iv = buffer.writableSegment(minimumCapacity);
        byte[] data$iv = tail$iv.dataAsByteArray(false);
        int n2 = data$iv.length;
        int n3 = tail$iv.getLimit();
        byte[] rawData = data$iv;
        boolean bl = false;
        ByteBuffer bb = ByteBuffer.wrap(rawData, (int)pos, (int)(limit - pos)).slice();
        Intrinsics.checkNotNull(bb);
        writeAction2.invoke(bb);
        int bytesWritten$iv = bb.position();
        if (bytesWritten$iv == minimumCapacity) {
            tail$iv.writeBackData(data$iv, bytesWritten$iv);
            tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
            buffer.setSizeMut(buffer.getSizeMut() + (long)bytesWritten$iv);
            n = bytesWritten$iv;
        } else {
            if (!(0 <= bytesWritten$iv ? bytesWritten$iv <= tail$iv.getRemainingCapacity() : false)) {
                boolean bl2 = false;
                String string = "Invalid number of bytes written: " + bytesWritten$iv + ". Should be in 0.." + tail$iv.getRemainingCapacity();
                throw new IllegalStateException(string.toString());
            }
            if (bytesWritten$iv != 0) {
                tail$iv.writeBackData(data$iv, bytesWritten$iv);
                tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                buffer.setSizeMut(buffer.getSizeMut() + (long)bytesWritten$iv);
                n = bytesWritten$iv;
            } else {
                if (SegmentKt.isEmpty(tail$iv)) {
                    buffer.recycleTail();
                }
                n = bytesWritten$iv;
            }
        }
        return n;
    }

    @UnsafeIoApi
    public static final long readBulk(@NotNull UnsafeBufferOperations $this$readBulk, @NotNull Buffer buffer, @NotNull ByteBuffer[] iovec, @NotNull Function2<? super ByteBuffer[], ? super Integer, Long> readAction) {
        Intrinsics.checkNotNullParameter($this$readBulk, "<this>");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(iovec, "iovec");
        Intrinsics.checkNotNullParameter(readAction, "readAction");
        boolean $i$f$readBulk = false;
        Segment segment = buffer.getHead();
        if (segment == null) {
            throw new IllegalArgumentException("buffer is empty.");
        }
        Segment head = segment;
        if (iovec.length == 0) {
            throw new IllegalArgumentException("iovec is empty.");
        }
        Segment currentSegment = head;
        int idx = 0;
        long capacity = 0L;
        do {
            int pos = currentSegment.getPos();
            int limit = currentSegment.getLimit();
            int len = limit - pos;
            iovec[idx++] = ByteBuffer.wrap(currentSegment.dataAsByteArray(true), pos, len).slice().asReadOnlyBuffer();
            capacity += (long)len;
        } while (currentSegment.getNext() != null && idx < iovec.length);
        long bytesRead = ((Number)readAction.invoke((ByteBuffer[])iovec, (Integer)idx)).longValue();
        if (bytesRead != 0L) {
            if (bytesRead < 0L || bytesRead > capacity) {
                throw new IllegalStateException("readAction should return a value in range [0, " + capacity + "], but returned: " + bytesRead);
            }
            buffer.skip(bytesRead);
        }
        return bytesRead;
    }
}

