/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.packaging.jpackage;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.ui.ArtifactProblemsHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.JavaFXBundle;

public final class JPackageArtifactType
extends ArtifactType {
    private JPackageArtifactType() {
        super("jpackage", () -> JavaFXBundle.message("platform.specific.package", new Object[0]));
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Nodes.Artifact;
        if (icon == null) {
            JPackageArtifactType.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @Nullable
    public String getDefaultPathFor(@NotNull PackagingElementOutputKind kind) {
        if (kind == null) {
            JPackageArtifactType.$$$reportNull$$$0(1);
        }
        return "/";
    }

    @NotNull
    public CompositePackagingElement<?> createRootElement(@NotNull String artifactName) {
        if (artifactName == null) {
            JPackageArtifactType.$$$reportNull$$$0(2);
        }
        ArtifactRootElement artifactRootElement = PackagingElementFactory.getInstance().createArtifactRootElement();
        if (artifactRootElement == null) {
            JPackageArtifactType.$$$reportNull$$$0(3);
        }
        return artifactRootElement;
    }

    public void checkRootElement(@NotNull CompositePackagingElement<?> rootElement, @NotNull Artifact artifact, @NotNull ArtifactProblemsHolder manager) {
        Project project;
        Sdk sdk;
        if (rootElement == null) {
            JPackageArtifactType.$$$reportNull$$$0(4);
        }
        if (artifact == null) {
            JPackageArtifactType.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            JPackageArtifactType.$$$reportNull$$$0(6);
        }
        if ((sdk = JPackageArtifactType.getJPackageCompatibleSdk(artifact, project = manager.getContext().getProject())) == null) {
            manager.registerError(JavaFXBundle.message("needs.at.least.jdk.14.containing.the.jpackage.tool", new Object[0]), "no-jpackage");
        }
    }

    public static Sdk getJPackageCompatibleSdk(Artifact artifact, Project project) {
        Set modules = (Set)ReadAction.compute(() -> ArtifactUtil.getModulesIncludedInArtifacts(Collections.singletonList(artifact), (Project)project));
        if (modules.isEmpty()) {
            return null;
        }
        for (Module module : modules) {
            SdkTypeId sdkType;
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (sdk == null || !((sdkType = sdk.getSdkType()) instanceof JavaSdk) || !((JavaSdk)sdkType).isOfVersionOrHigher(sdk, JavaSdkVersion.JDK_14)) continue;
            return sdk;
        }
        return null;
    }

    @NotNull
    public List<? extends ArtifactTemplate> getNewArtifactTemplates(@NotNull PackagingElementResolvingContext context) {
        if (context == null) {
            JPackageArtifactType.$$$reportNull$$$0(7);
        }
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Module module : context.getModulesProvider().getModules()) {
            if (!(ModuleType.get((Module)module) instanceof JavaModuleType)) continue;
            modules.add(module);
        }
        if (modules.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                JPackageArtifactType.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<JPackageArtifactTemplate> list = Collections.singletonList(new JPackageArtifactTemplate(modules));
        if (list == null) {
            JPackageArtifactType.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/packaging/jpackage/JPackageArtifactType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/packaging/jpackage/JPackageArtifactType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRootElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewArtifactTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPathFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRootElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkRootElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNewArtifactTemplates";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private final class JPackageArtifactTemplate
    extends ArtifactTemplate {
        private final List<Module> myModules;

        JPackageArtifactTemplate(List<Module> modules) {
            this.myModules = modules;
        }

        public String getPresentableName() {
            if (this.myModules.size() == 1) {
                return JavaFXBundle.message("action.from.modules.artifact.text", this.myModules.get(0).getName());
            }
            return JavaFXBundle.message("action.from.module.artifact.text", new Object[0]);
        }

        public ArtifactTemplate.NewArtifactConfiguration createArtifact() {
            Module module;
            if (this.myModules.size() == 1) {
                module = this.myModules.get(0);
            } else {
                ChooseModulesDialog dialog = new ChooseModulesDialog(this.myModules.get(0).getProject(), this.myModules, JavaFXBundle.message("dialog.title.select.module.for.artifact", new Object[0]), JavaFXBundle.message("label.selected.module.output.would.to.be.included.in.artifact", new Object[0]));
                dialog.setSingleSelectionMode();
                if (dialog.showAndGet()) {
                    List elements = dialog.getChosenElements();
                    if (elements.isEmpty()) {
                        return null;
                    }
                    module = (Module)elements.get(0);
                } else {
                    module = null;
                }
            }
            if (module == null) {
                return null;
            }
            CompositePackagingElement<?> rootElement = JPackageArtifactType.this.createRootElement(module.getName());
            CompositePackagingElement subElement = PackagingElementFactory.getInstance().createArchive(FileUtil.sanitizeFileName((String)module.getName()) + ".jar");
            PackagingElement moduleOutputElement = PackagingElementFactory.getInstance().createModuleOutput(module);
            subElement.addFirstChild(moduleOutputElement);
            rootElement.addFirstChild((PackagingElement)subElement);
            return new ArtifactTemplate.NewArtifactConfiguration(rootElement, module.getName(), (ArtifactType)JPackageArtifactType.this);
        }
    }
}

