/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInsight.navigation.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaPsiConstructorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public final class GroovyGotoSuperHandler
extends GotoTargetHandler
implements LanguageCodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance(GroovyGotoSuperHandler.class);

    protected String getFeatureUsedKey() {
        return "navigation.goto.super";
    }

    protected GotoTargetHandler.GotoData getSourceAndTargetElements(Editor editor, PsiFile file) {
        PsiMember e = GroovyGotoSuperHandler.findSource(editor, file);
        if (e == null) {
            return null;
        }
        return new GotoTargetHandler.GotoData((PsiElement)e, GroovyGotoSuperHandler.findTargets(e), Collections.emptyList());
    }

    @NotNull
    protected String getChooserTitle(@NotNull PsiElement sourceElement, String name, int length, boolean finished) {
        if (sourceElement == null) {
            GroovyGotoSuperHandler.$$$reportNull$$$0(0);
        }
        String string = CodeInsightBundle.message((String)"goto.super.method.chooser.title", (Object[])new Object[0]);
        if (string == null) {
            GroovyGotoSuperHandler.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected String getFindUsagesTitle(@NotNull PsiElement sourceElement, String name, int length) {
        if (sourceElement == null) {
            GroovyGotoSuperHandler.$$$reportNull$$$0(2);
        }
        String string = CodeInsightBundle.message((String)"goto.super.method.findUsages.title", (Object[])new Object[]{name});
        if (string == null) {
            GroovyGotoSuperHandler.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    protected String getNotFoundMessage(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiMember source;
        if (project == null) {
            GroovyGotoSuperHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            GroovyGotoSuperHandler.$$$reportNull$$$0(5);
        }
        if (file == null) {
            GroovyGotoSuperHandler.$$$reportNull$$$0(6);
        }
        if ((source = GroovyGotoSuperHandler.findSource(editor, file)) instanceof PsiClass) {
            String string = GroovyBundle.message("no.super.classes.found", new Object[0]);
            if (string == null) {
                GroovyGotoSuperHandler.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (source instanceof PsiMethod || source instanceof GrField) {
            String string = GroovyBundle.message("no.super.method.found", new Object[0]);
            if (string == null) {
                GroovyGotoSuperHandler.$$$reportNull$$$0(8);
            }
            return string;
        }
        throw new IncorrectOperationException("incorrect element is found: " + (source == null ? "null" : source.getClass().getCanonicalName()));
    }

    @Nullable
    private static PsiMember findSource(Editor editor, PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element == null) {
            return null;
        }
        return (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, GrField.class, PsiClass.class});
    }

    private static PsiElement @NotNull [] findTargets(@NotNull PsiMember e) {
        if (e == null) {
            GroovyGotoSuperHandler.$$$reportNull$$$0(9);
        }
        if (e instanceof PsiClass) {
            PsiClass aClass = (PsiClass)e;
            ArrayList<PsiClass> allSupers = new ArrayList<PsiClass>(Arrays.asList(aClass.getSupers()));
            Iterator iterator2 = allSupers.iterator();
            while (iterator2.hasNext()) {
                PsiClass superClass = (PsiClass)iterator2.next();
                if (!"java.lang.Object".equals(superClass.getQualifiedName())) continue;
                iterator2.remove();
            }
            PsiElement[] psiElementArray = (PsiElement[])allSupers.toArray(PsiClass.EMPTY_ARRAY);
            if (psiElementArray == null) {
                GroovyGotoSuperHandler.$$$reportNull$$$0(10);
            }
            return psiElementArray;
        }
        if (e instanceof PsiMethod) {
            return GroovyGotoSuperHandler.getSupers((PsiMethod)e);
        }
        LOG.assertTrue(e instanceof GrField);
        ArrayList<PsiMethod> supers = new ArrayList<PsiMethod>();
        for (GrAccessorMethod method : GroovyPropertyUtils.getFieldAccessors((GrField)e)) {
            supers.addAll(Arrays.asList(GroovyGotoSuperHandler.getSupers(method)));
        }
        PsiElement[] psiElementArray = (PsiElement[])supers.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiElementArray == null) {
            GroovyGotoSuperHandler.$$$reportNull$$$0(11);
        }
        return psiElementArray;
    }

    private static PsiMethod @NotNull [] getSupers(PsiMethod method) {
        if (method.isConstructor()) {
            PsiMethod constructorInSuper = JavaPsiConstructorUtil.findConstructorInSuper((PsiMethod)method);
            if (constructorInSuper != null) {
                PsiMethod[] psiMethodArray = new PsiMethod[]{constructorInSuper};
                if (psiMethodArray == null) {
                    GroovyGotoSuperHandler.$$$reportNull$$$0(12);
                }
                return psiMethodArray;
            }
        } else {
            PsiMethod[] psiMethodArray = method.findSuperMethods(false);
            if (psiMethodArray == null) {
                GroovyGotoSuperHandler.$$$reportNull$$$0(13);
            }
            return psiMethodArray;
        }
        if (PsiMethod.EMPTY_ARRAY == null) {
            GroovyGotoSuperHandler.$$$reportNull$$$0(14);
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    public boolean isValidFor(Editor editor, PsiFile file) {
        return file != null && ((Object)((Object)GroovyFileType.GROOVY_FILE_TYPE)).equals(file.getFileType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 7, 8, 10, 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInsight/navigation/actions/GroovyGotoSuperHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInsight/navigation/actions/GroovyGotoSuperHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChooserTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesTitle";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotFoundMessage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findTargets";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChooserTitle";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFindUsagesTitle";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNotFoundMessage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findTargets";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 7, 8, 10, 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }
}

