/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class SelectAllAction
extends Action {
    private final IWorkbenchPart part;

    public SelectAllAction(IWorkbenchPart part) {
        this.part = part;
        this.setText(GEFMessages.SelectAllAction_Label);
        this.setToolTipText(GEFMessages.SelectAllAction_Tooltip);
        this.setId(ActionFactory.SELECT_ALL.getId());
    }

    public void run() {
        GraphicalViewer viewer = (GraphicalViewer)this.part.getAdapter(GraphicalViewer.class);
        if (viewer != null) {
            viewer.setSelection((ISelection)new StructuredSelection(SelectAllAction.getSelectableEditParts(viewer)));
        }
    }

    private static List<? extends EditPart> getSelectableEditParts(GraphicalViewer viewer) {
        return viewer.getContents().getChildren().stream().filter(EditPart::isSelectable).toList();
    }
}

