/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.plan;

import java.sql.ResultSet;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanNodeType;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanObject;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanOperator;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.utils.CommonUtils;

public class DB2PlanStream {
    private DB2PlanStatement db2Statement;
    private Integer streamId;
    private DB2PlanNodeType sourceType;
    private Integer sourceId;
    private DB2PlanNodeType targetType;
    private Integer targetId;
    private String objectSchema;
    private String objectName;
    private Double streamCount;

    public DB2PlanStream(JDBCResultSet dbResult, DB2PlanStatement db2Statement) {
        this.db2Statement = db2Statement;
        this.streamId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"STREAM_ID");
        this.sourceType = (DB2PlanNodeType)CommonUtils.valueOf(DB2PlanNodeType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SOURCE_TYPE"));
        this.sourceId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"SOURCE_ID");
        this.targetType = (DB2PlanNodeType)CommonUtils.valueOf(DB2PlanNodeType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TARGET_TYPE"));
        this.targetId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"TARGET_ID");
        this.objectSchema = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"OBJECT_SCHEMA");
        this.objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_NAME");
        this.streamCount = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"STREAM_COUNT");
    }

    public String getSourceName() {
        if (this.sourceType.equals((Object)DB2PlanNodeType.O)) {
            return DB2PlanOperator.buildName(this.sourceId);
        }
        return DB2PlanObject.buildName(this.objectSchema, this.objectName);
    }

    public String getTargetName() {
        if (this.targetType.equals((Object)DB2PlanNodeType.O)) {
            return DB2PlanOperator.buildName(this.targetId);
        }
        return DB2PlanObject.buildName(this.objectSchema, this.objectName);
    }

    public Integer getStreamId() {
        return this.streamId;
    }

    public DB2PlanNodeType getSourceType() {
        return this.sourceType;
    }

    public Integer getSourceId() {
        return this.sourceId;
    }

    public DB2PlanNodeType getTargetType() {
        return this.targetType;
    }

    public Integer getTargetId() {
        return this.targetId;
    }

    public String getObjectSchema() {
        return this.objectSchema;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public DB2PlanStatement getDb2Statement() {
        return this.db2Statement;
    }

    public Double getStreamCount() {
        return this.streamCount;
    }
}

