﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {

/**
 * <p>Information about an Availability Zone.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AvailabilityZone">AWS
 * API Reference</a></p>
 */
class AvailabilityZone {
 public:
  AWS_SECURITYHUB_API AvailabilityZone() = default;
  AWS_SECURITYHUB_API AvailabilityZone(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API AvailabilityZone& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the Availability Zone.</p>
   */
  inline const Aws::String& GetZoneName() const { return m_zoneName; }
  inline bool ZoneNameHasBeenSet() const { return m_zoneNameHasBeenSet; }
  template <typename ZoneNameT = Aws::String>
  void SetZoneName(ZoneNameT&& value) {
    m_zoneNameHasBeenSet = true;
    m_zoneName = std::forward<ZoneNameT>(value);
  }
  template <typename ZoneNameT = Aws::String>
  AvailabilityZone& WithZoneName(ZoneNameT&& value) {
    SetZoneName(std::forward<ZoneNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the subnet. You can specify one subnet per Availability Zone.</p>
   */
  inline const Aws::String& GetSubnetId() const { return m_subnetId; }
  inline bool SubnetIdHasBeenSet() const { return m_subnetIdHasBeenSet; }
  template <typename SubnetIdT = Aws::String>
  void SetSubnetId(SubnetIdT&& value) {
    m_subnetIdHasBeenSet = true;
    m_subnetId = std::forward<SubnetIdT>(value);
  }
  template <typename SubnetIdT = Aws::String>
  AvailabilityZone& WithSubnetId(SubnetIdT&& value) {
    SetSubnetId(std::forward<SubnetIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_zoneName;

  Aws::String m_subnetId;
  bool m_zoneNameHasBeenSet = false;
  bool m_subnetIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
