/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.duckdb.DuckDBConnection;
import org.duckdb.DuckDBNative;
import org.duckdb.JdbcUtils;
import org.duckdb.io.IOUtils;
import org.duckdb.io.LimitedInputStream;

public class DuckDBDriver
implements Driver {
    public static final String DUCKDB_READONLY_PROPERTY = "duckdb.read_only";
    public static final String DUCKDB_USER_AGENT_PROPERTY = "custom_user_agent";
    public static final String JDBC_STREAM_RESULTS = "jdbc_stream_results";
    public static final String JDBC_AUTO_COMMIT = "jdbc_auto_commit";
    public static final String JDBC_PIN_DB = "jdbc_pin_db";
    public static final String JDBC_IGNORE_UNSUPPORTED_OPTIONS = "jdbc_ignore_unsupported_options";
    static final String DUCKDB_URL_PREFIX = "jdbc:duckdb:";
    static final String MEMORY_DB = ":memory:";
    private static final String DUCKLAKE_URL_PREFIX = "jdbc:duckdb:ducklake:";
    static final ScheduledThreadPoolExecutor scheduler;
    private static final LinkedHashMap<String, ByteBuffer> pinnedDbRefs;
    private static final ReentrantLock pinnedDbRefsLock;
    private static boolean pinnedDbRefsShutdownHookRegistered;
    private static boolean pinnedDbRefsShutdownHookRun;
    private static final Set<String> supportedOptions;
    private static final ReentrantLock supportedOptionsLock;
    private static final String SESSION_INIT_SQL_FILE_OPTION = "session_init_sql_file";
    private static final String SESSION_INIT_SQL_FILE_SHA256_OPTION = "session_init_sql_file_sha256";
    private static final long SESSION_INIT_SQL_FILE_MAX_SIZE_BYTES = 0x100000L;
    private static final String SESSION_INIT_SQL_FILE_URL_EXAMPLE = "jdbc:duckdb:/path/to/db1.db;session_init_sql_file=/path/to/init.sql;session_init_sql_file_sha256=...";
    private static final String SESSION_INIT_SQL_CONN_INIT_MARKER = "/\\*\\s*DUCKDB_CONNECTION_INIT_BELOW_MARKER\\s*\\*/";
    private static final LinkedHashSet<String> sessionInitSQLFileDbNames;
    private static final ReentrantLock sessionInitSQLFileLock;

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties props = info == null ? new Properties() : (Properties)info.clone();
        ParsedProps pp = DuckDBDriver.parsePropsFromUrl(url);
        SessionInitSQLFile sf = DuckDBDriver.readSessionInitSQLFile(pp);
        for (Map.Entry<String, String> en : pp.props.entrySet()) {
            props.put(en.getKey(), en.getValue());
        }
        DuckDBDriver.removeUnsupportedOptions(props);
        String readOnlyStr = JdbcUtils.removeOption(props, DUCKDB_READONLY_PROPERTY);
        boolean readOnly = JdbcUtils.isStringTruish(readOnlyStr, false);
        props.put("duckdb_api", "jdbc");
        props.remove("path");
        if (pp.shortUrl.startsWith(DUCKLAKE_URL_PREFIX)) {
            JdbcUtils.setDefaultOptionValue(props, JDBC_PIN_DB, true);
            JdbcUtils.setDefaultOptionValue(props, JDBC_STREAM_RESULTS, true);
        }
        String pinDbOptStr = JdbcUtils.removeOption(props, JDBC_PIN_DB);
        boolean pinDBOpt = JdbcUtils.isStringTruish(pinDbOptStr, false);
        DuckDBConnection conn = DuckDBConnection.newConnection(pp.shortUrl, readOnly, sf.origFileText, props);
        try {
            DuckDBDriver.pinDB(pinDBOpt, pp.shortUrl, conn);
            DuckDBDriver.runSessionInitSQLFile(conn, pp.shortUrl, sf);
        }
        catch (SQLException e) {
            JdbcUtils.closeQuietly(conn);
            throw e;
        }
        return conn;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return null != url && url.startsWith(DUCKDB_URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        ArrayList<DriverPropertyInfo> list = new ArrayList<DriverPropertyInfo>();
        try (Connection conn = DriverManager.getConnection(url, info);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT name, value, description FROM duckdb_settings()");){
            while (rs.next()) {
                String name = rs.getString(1);
                String value = rs.getString(2);
                String description = rs.getString(3);
                list.add(DuckDBDriver.createDriverPropInfo(name, value, description));
            }
        }
        list.add(DuckDBDriver.createDriverPropInfo(DUCKDB_READONLY_PROPERTY, "", "Set connection to read-only mode"));
        list.add(DuckDBDriver.createDriverPropInfo(DUCKDB_USER_AGENT_PROPERTY, "", "Custom user agent string"));
        list.add(DuckDBDriver.createDriverPropInfo(JDBC_STREAM_RESULTS, "", "Enable result set streaming"));
        list.add(DuckDBDriver.createDriverPropInfo(JDBC_AUTO_COMMIT, "", "Set default auto-commit mode"));
        list.add(DuckDBDriver.createDriverPropInfo(JDBC_PIN_DB, "", "Do not close the DB instance after all connections to it are closed"));
        list.add(DuckDBDriver.createDriverPropInfo(JDBC_IGNORE_UNSUPPORTED_OPTIONS, "", "Silently discard unsupported connection options"));
        list.sort((o1, o2) -> o1.name.compareToIgnoreCase(o2.name));
        return list.toArray(new DriverPropertyInfo[0]);
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("no logger");
    }

    private static ParsedProps parsePropsFromUrl(String url) throws SQLException {
        if (!url.contains(";")) {
            return new ParsedProps(url);
        }
        String[] parts = url.split(";");
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        ArrayList<String> origPropNames = new ArrayList<String>();
        for (int i = 1; i < parts.length; ++i) {
            String entry = parts[i].trim();
            if (entry.isEmpty()) continue;
            String[] kv = entry.split("=");
            if (2 != kv.length) {
                throw new SQLException("Invalid URL entry: " + entry);
            }
            String key = kv[0].trim();
            String value = kv[1].trim();
            origPropNames.add(key);
            props.put(key, value);
        }
        String shortUrl = parts[0].trim();
        return new ParsedProps(shortUrl, props, origPropNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pinDB(boolean pinnedDbOpt, String url, DuckDBConnection conn) throws SQLException {
        if (!pinnedDbOpt) {
            return;
        }
        String dbName = JdbcUtils.dbNameFromUrl(url);
        if (MEMORY_DB.equals(dbName)) {
            return;
        }
        pinnedDbRefsLock.lock();
        try {
            if (pinnedDbRefsShutdownHookRun || pinnedDbRefs.containsKey(dbName)) {
                return;
            }
            ByteBuffer dbRef = DuckDBNative.duckdb_jdbc_create_db_ref(conn.connRef);
            pinnedDbRefs.put(dbName, dbRef);
            if (!pinnedDbRefsShutdownHookRegistered) {
                Runtime.getRuntime().addShutdownHook(new Thread(new PinnedDbRefsShutdownHook()));
                pinnedDbRefsShutdownHookRegistered = true;
            }
        }
        finally {
            pinnedDbRefsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean releaseDB(String url) throws SQLException {
        pinnedDbRefsLock.lock();
        try {
            if (pinnedDbRefsShutdownHookRun) {
                boolean bl = false;
                return bl;
            }
            String dbName = JdbcUtils.dbNameFromUrl(url);
            ByteBuffer dbRef = (ByteBuffer)pinnedDbRefs.remove(dbName);
            if (null == dbRef) {
                boolean bl = false;
                return bl;
            }
            DuckDBNative.duckdb_jdbc_destroy_db_ref(dbRef);
            boolean bl = true;
            return bl;
        }
        finally {
            pinnedDbRefsLock.unlock();
        }
    }

    private static DriverPropertyInfo createDriverPropInfo(String name, String value, String description) {
        DriverPropertyInfo dpi = new DriverPropertyInfo(name, value);
        dpi.description = description;
        return dpi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeUnsupportedOptions(Properties props) throws SQLException {
        String ignoreStr = JdbcUtils.removeOption(props, JDBC_IGNORE_UNSUPPORTED_OPTIONS);
        boolean ignore = JdbcUtils.isStringTruish(ignoreStr, false);
        if (!ignore) {
            return;
        }
        supportedOptionsLock.lock();
        try {
            if (supportedOptions.isEmpty()) {
                DriverPropertyInfo[] dpis;
                Driver driver = DriverManager.getDriver(DUCKDB_URL_PREFIX);
                Properties dpiProps = new Properties();
                dpiProps.put("threads", (Object)1);
                for (DriverPropertyInfo dpi : dpis = driver.getPropertyInfo(DUCKDB_URL_PREFIX, dpiProps)) {
                    supportedOptions.add(dpi.name);
                }
            }
            ArrayList<String> unsupportedNames = new ArrayList<String>();
            for (Object nameObj : props.keySet()) {
                String name = String.valueOf(nameObj);
                if (supportedOptions.contains(name)) continue;
                unsupportedNames.add(name);
            }
            for (String name : unsupportedNames) {
                props.remove(name);
            }
        }
        finally {
            supportedOptionsLock.unlock();
        }
    }

    private static SessionInitSQLFile readSessionInitSQLFile(ParsedProps pp) throws SQLException {
        String actualSha256;
        String origFileText;
        String expectedSha256;
        if (!pp.props.containsKey(SESSION_INIT_SQL_FILE_OPTION)) {
            return new SessionInitSQLFile();
        }
        ArrayList<String> urlOptsList = new ArrayList<String>(pp.props.keySet());
        if (!SESSION_INIT_SQL_FILE_OPTION.equals(urlOptsList.get(0))) {
            throw new SQLException("'session_init_sql_file' can only be specified as the first parameter in connection string, example: 'jdbc:duckdb:/path/to/db1.db;session_init_sql_file=/path/to/init.sql;session_init_sql_file_sha256=...'");
        }
        for (int i = 1; i < pp.origPropNames.size(); ++i) {
            if (!SESSION_INIT_SQL_FILE_OPTION.equalsIgnoreCase(pp.origPropNames.get(i))) continue;
            throw new SQLException("'session_init_sql_file' option cannot be specified more than once");
        }
        String filePathStr = (String)pp.props.remove(SESSION_INIT_SQL_FILE_OPTION);
        if (pp.props.containsKey(SESSION_INIT_SQL_FILE_SHA256_OPTION)) {
            if (!SESSION_INIT_SQL_FILE_SHA256_OPTION.equals(urlOptsList.get(1))) {
                throw new SQLException("'session_init_sql_file_sha256' can only be specified as the second parameter in connection string, example: 'jdbc:duckdb:/path/to/db1.db;session_init_sql_file=/path/to/init.sql;session_init_sql_file_sha256=...'");
            }
            for (int i = 2; i < pp.origPropNames.size(); ++i) {
                if (!SESSION_INIT_SQL_FILE_SHA256_OPTION.equalsIgnoreCase(pp.origPropNames.get(i))) continue;
                throw new SQLException("'session_init_sql_file_sha256' option cannot be specified more than once");
            }
            expectedSha256 = (String)pp.props.remove(SESSION_INIT_SQL_FILE_SHA256_OPTION);
        } else {
            expectedSha256 = "";
        }
        Path filePath = Paths.get(filePathStr, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw new SQLException("Specified session init SQL file not found, path: " + filePath);
        }
        try {
            long fileSize = Files.size(filePath);
            if (fileSize > 0x100000L) {
                throw new SQLException("Specified session init SQL file size: " + fileSize + " exceeds max allowed size: " + 0x100000L);
            }
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            try (DigestInputStream is = new DigestInputStream(new LimitedInputStream(Files.newInputStream(filePath, StandardOpenOption.READ), fileSize), md);){
                InputStreamReader reader = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);
                origFileText = IOUtils.readToString(reader);
                actualSha256 = JdbcUtils.bytesToHex(md.digest());
            }
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        if (!expectedSha256.isEmpty() && !expectedSha256.toLowerCase().equals(actualSha256)) {
            throw new SQLException("Session init SQL file SHA-256 mismatch, expected: " + expectedSha256 + ", actual: " + actualSha256);
        }
        String[] parts = origFileText.split(SESSION_INIT_SQL_CONN_INIT_MARKER);
        if (parts.length > 2) {
            throw new SQLException("Connection init marker: '/\\*\\s*DUCKDB_CONNECTION_INIT_BELOW_MARKER\\s*\\*/' can only be specified once");
        }
        if (1 == parts.length) {
            return new SessionInitSQLFile(origFileText, parts[0].trim());
        }
        return new SessionInitSQLFile(origFileText, parts[0].trim(), parts[1].trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runSessionInitSQLFile(Connection conn, String url, SessionInitSQLFile sf) throws SQLException {
        block31: {
            if (sf.isEmpty()) {
                return;
            }
            sessionInitSQLFileLock.lock();
            try {
                if (!sf.dbInitSQL.isEmpty()) {
                    String dbName = JdbcUtils.dbNameFromUrl(url);
                    if (MEMORY_DB.equals(dbName) || !sessionInitSQLFileDbNames.contains(dbName)) {
                        try (Statement stmt = conn.createStatement();){
                            stmt.execute(sf.dbInitSQL);
                        }
                    }
                    sessionInitSQLFileDbNames.add(dbName);
                }
                if (sf.connInitSQL.isEmpty()) break block31;
                try (Statement stmt = conn.createStatement();){
                    stmt.execute(sf.connInitSQL);
                }
            }
            finally {
                sessionInitSQLFileLock.unlock();
            }
        }
    }

    static {
        pinnedDbRefs = new LinkedHashMap();
        pinnedDbRefsLock = new ReentrantLock();
        pinnedDbRefsShutdownHookRegistered = false;
        pinnedDbRefsShutdownHookRun = false;
        supportedOptions = new LinkedHashSet<String>();
        supportedOptionsLock = new ReentrantLock();
        sessionInitSQLFileDbNames = new LinkedHashSet();
        sessionInitSQLFileLock = new ReentrantLock();
        try {
            DriverManager.registerDriver(new DuckDBDriver());
            ThreadFactory tf = r -> new Thread(r, "duckdb-query-cancel-scheduler-thread");
            scheduler = new ScheduledThreadPoolExecutor(1, tf);
            scheduler.setRemoveOnCancelPolicy(true);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static class SessionInitSQLFile {
        final String dbInitSQL;
        final String connInitSQL;
        final String origFileText;

        private SessionInitSQLFile() {
            this((String)null, (String)null, (String)null);
        }

        private SessionInitSQLFile(String origFileText, String dbInitSQL) {
            this(origFileText, dbInitSQL, "");
        }

        private SessionInitSQLFile(String origFileText, String dbInitSQL, String connInitSQL) {
            this.origFileText = origFileText;
            this.dbInitSQL = dbInitSQL;
            this.connInitSQL = connInitSQL;
        }

        boolean isEmpty() {
            return null == this.dbInitSQL && null == this.connInitSQL && null == this.origFileText;
        }
    }

    private static class PinnedDbRefsShutdownHook
    implements Runnable {
        private PinnedDbRefsShutdownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            pinnedDbRefsLock.lock();
            try {
                ArrayList dbRefsList = new ArrayList(pinnedDbRefs.values());
                Collections.reverse(dbRefsList);
                for (ByteBuffer dbRef : dbRefsList) {
                    DuckDBNative.duckdb_jdbc_destroy_db_ref(dbRef);
                }
                pinnedDbRefsShutdownHookRun = true;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                pinnedDbRefsLock.unlock();
            }
        }
    }

    private static class ParsedProps {
        final String shortUrl;
        final LinkedHashMap<String, String> props;
        final List<String> origPropNames;

        private ParsedProps(String url) {
            this(url, new LinkedHashMap<String, String>(), new ArrayList<String>());
        }

        private ParsedProps(String shortUrl, LinkedHashMap<String, String> props, List<String> origPropNames) {
            this.shortUrl = shortUrl;
            this.props = props;
            this.origPropNames = origPropNames;
        }
    }
}

