/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.helpersLocator;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerCoreKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\bg\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0002J\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0017J$\u0010\t\u001a\u00020\u00032\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0017J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0003\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lcom/intellij/python/community/helpersLocator/PythonHelpersLocator;", "", "getRoot", "Ljava/nio/file/Path;", "getCommunityHelpersRootPath", "getHelpersRoot", "moduleName", "", "relativePath", "findRootByJarPath", "aClass", "Ljava/lang/Class;", "getPluginBaseDir", "jarPath", "assertHelpersLayout", "root", "Companion", "intellij.python.community.helpersLocator"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPythonHelpersLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonHelpersLocator.kt\ncom/intellij/python/community/helpersLocator/PythonHelpersLocator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1869#2,2:168\n*S KotlinDebug\n*F\n+ 1 PythonHelpersLocator.kt\ncom/intellij/python/community/helpersLocator/PythonHelpersLocator\n*L\n158#1:168,2\n*E\n"})
public interface PythonHelpersLocator {
    @NotNull
    public static final Companion Companion = com.intellij.python.community.helpersLocator.PythonHelpersLocator$Companion.$$INSTANCE;
    @NotNull
    public static final String COMMUNITY_HELPERS_MODULE_NAME = "intellij.python.helpers";

    @ApiStatus.Internal
    @Nullable
    default public Path getRoot() {
        return this.getCommunityHelpersRootPath().normalize();
    }

    private Path getCommunityHelpersRootPath() {
        Path path2;
        String property = System.getProperty("idea.python.helpers.path");
        if (property != null) {
            Path path3 = Path.of(property, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"of(...)");
            return path3;
        }
        Path it = path2 = this.getHelpersRoot(COMMUNITY_HELPERS_MODULE_NAME, "/python/helpers");
        boolean bl = false;
        this.assertHelpersLayout(it);
        return path2;
    }

    @ApiStatus.Internal
    @RequiresBackgroundThread
    @NotNull
    default public Path getHelpersRoot(@NotNull String moduleName, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return this.findRootByJarPath(PythonHelpersLocator.class, moduleName, relativePath);
    }

    @ApiStatus.Internal
    @NotNull
    default public Path findRootByJarPath(@NotNull Class<?> aClass, @NotNull String moduleName, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        if (PluginManagerCore.isRunningFromSources()) {
            String[] stringArray = new String[]{relativePath};
            Path path2 = Path.of(PathManager.getCommunityHomePath(), stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
            return path2;
        }
        Path path3 = PluginManagerCoreKt.getPluginDistDirByClass(aClass);
        if (path3 != null) {
            Path it = path3;
            boolean bl = false;
            Path path4 = it.resolve(PathUtil.getFileName((String)relativePath));
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            return path4;
        }
        String string = PathUtil.getJarPathForClass(aClass);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJarPathForClass(...)");
        String jarPath = string;
        Path path5 = this.getPluginBaseDir(jarPath);
        if (path5 != null) {
            Path it = path5;
            boolean bl = false;
            Path path6 = it.resolve(PathUtil.getFileName((String)relativePath));
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
            return path6;
        }
        Path path7 = Path.of(jarPath, new String[0]).getParent().toAbsolutePath().resolve(moduleName);
        Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"resolve(...)");
        return path7;
    }

    private Path getPluginBaseDir(String jarPath) {
        if (StringsKt.endsWith$default((String)jarPath, (String)".jar", (boolean)false, (int)2, null)) {
            Path path2 = Path.of(jarPath, new String[0]);
            Logger logger = Companion.getLOG();
            Intrinsics.checkNotNull((Object)path2);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            logger.assertTrue(Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)), (Object)(path2 + " to plugin base bir does not exists"));
            return path2.getParent().getParent();
        }
        return null;
    }

    @RequiresBackgroundThread
    private Path assertHelpersLayout(Path root) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        Companion.getLOG().assertTrue(Files.exists(root, Arrays.copyOf(linkOptionArray, linkOptionArray.length)), (Object)("Helpers root does not exist " + root));
        Object[] objectArray = new String[]{"generator3", "pycharm", "pycodestyle.py", "pydev", "syspath.py", "typeshed"};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path path2;
            String child = (String)element$iv;
            boolean bl = false;
            Logger logger = Companion.getLOG();
            Intrinsics.checkNotNullExpressionValue((Object)root.resolve(child), (String)"resolve(...)");
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            logger.assertTrue(Files.exists(path2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)), (Object)("No '" + child + "' inside " + root));
        }
        return root;
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static List<Path> getHelpersRoots() {
        return Companion.getHelpersRoots();
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static Path getCommunityHelpersRoot() {
        return Companion.getCommunityHelpersRoot();
    }

    @JvmStatic
    @RequiresBackgroundThread
    @NotNull
    public static Path findPathInHelpers(@NotNull String resourceName) {
        return Companion.findPathInHelpers(resourceName);
    }

    @JvmStatic
    @RequiresBackgroundThread
    @Nullable
    public static Path findPathInHelpersPossibleNull(@NotNull String resourceName) {
        return Companion.findPathInHelpersPossibleNull(resourceName);
    }

    @JvmStatic
    @ApiStatus.Internal
    @TestOnly
    @RequiresBackgroundThread
    @NotNull
    public static Path getPythonCommunityPath() {
        return Companion.getPythonCommunityPath();
    }

    @JvmStatic
    @ApiStatus.Internal
    @RequiresBackgroundThread
    @NotNull
    public static String findPathStringInHelpers(@NonNls @NotNull String resourceName) {
        return Companion.findPathStringInHelpers(resourceName);
    }

    @Deprecated(message="Use {@link PythonHelpersLocator#findPathInHelpers}.", replaceWith=@ReplaceWith(expression="findPathInHelpers(resourceName)", imports={}), level=DeprecationLevel.ERROR)
    @JvmStatic
    @NotNull
    public static String getHelperPath(@NonNls @NotNull String resourceName) {
        return Companion.getHelperPath(resourceName);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007J\b\u0010\u0014\u001a\u00020\u0013H\u0007J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\tH\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\tH\u0007J\b\u0010\u0018\u001a\u00020\u0013H\u0007J\u0012\u0010\u0019\u001a\u00020\t2\b\b\u0001\u0010\u0016\u001a\u00020\tH\u0007J\u0012\u0010\u001a\u001a\u00020\t2\b\b\u0001\u0010\u0016\u001a\u00020\tH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/python/community/helpersLocator/PythonHelpersLocator$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "PROPERTY_HELPERS_LOCATION", "", "COMMUNITY_HELPERS_MODULE_NAME", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/python/community/helpersLocator/PythonHelpersLocator;", "epNameForTests", "getEpNameForTests", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "getHelpersRoots", "", "Ljava/nio/file/Path;", "getCommunityHelpersRoot", "findPathInHelpers", "resourceName", "findPathInHelpersPossibleNull", "getPythonCommunityPath", "findPathStringInHelpers", "getHelperPath", "intellij.python.community.helpersLocator"})
    @SourceDebugExtension(value={"SMAP\nPythonHelpersLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonHelpersLocator.kt\ncom/intellij/python/community/helpersLocator/PythonHelpersLocator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,167:1\n1617#2,9:168\n1869#2:177\n1870#2:179\n1626#2:180\n1#3:178\n14#4:181\n*S KotlinDebug\n*F\n+ 1 PythonHelpersLocator.kt\ncom/intellij/python/community/helpersLocator/PythonHelpersLocator$Companion\n*L\n37#1:168,9\n37#1:177\n37#1:179\n37#1:180\n37#1:178\n23#1:181\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Logger LOG;
        @NotNull
        private static final String PROPERTY_HELPERS_LOCATION = "idea.python.helpers.path";
        @NotNull
        public static final String COMMUNITY_HELPERS_MODULE_NAME = "intellij.python.helpers";
        @NotNull
        private static final ExtensionPointName<PythonHelpersLocator> EP_NAME;
        @TestOnly
        @ApiStatus.Internal
        @NotNull
        private static final ExtensionPointName<PythonHelpersLocator> epNameForTests;

        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final ExtensionPointName<PythonHelpersLocator> getEpNameForTests() {
            return epNameForTests;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final List<Path> getHelpersRoots() {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = EP_NAME.getExtensionList();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Path it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                PythonHelpersLocator it = (PythonHelpersLocator)element$iv$iv;
                boolean bl2 = false;
                if (it.getRoot() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final Path getCommunityHelpersRoot() {
            return ((PythonHelpersLocator)CollectionsKt.first((List)com.intellij.python.community.helpersLocator.PythonHelpersLocator$Companion.EP_NAME.getExtensionList())).getCommunityHelpersRootPath();
        }

        @JvmStatic
        @RequiresBackgroundThread
        @NotNull
        public final Path findPathInHelpers(@NotNull String resourceName) {
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            Path path2 = this.findPathInHelpersPossibleNull(resourceName);
            if (path2 == null) {
                throw new IllegalStateException(("File " + resourceName + " does not exist in helpers root. Installation broken?").toString());
            }
            return path2;
        }

        @JvmStatic
        @RequiresBackgroundThread
        @Nullable
        public final Path findPathInHelpersPossibleNull(@NotNull String resourceName) {
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            for (Path helperRoot : this.getHelpersRoots()) {
                String[] stringArray = new String[]{resourceName};
                Path path2 = Path.of(((Object)helperRoot).toString(), stringArray);
                Intrinsics.checkNotNull((Object)path2);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                return path2;
            }
            return null;
        }

        @JvmStatic
        @ApiStatus.Internal
        @TestOnly
        @RequiresBackgroundThread
        @NotNull
        public final Path getPythonCommunityPath() {
            String[] stringArray = new String[]{"community/python"};
            Path pathFromUltimate = Path.of(PathManager.getHomePath(), stringArray);
            Intrinsics.checkNotNull((Object)pathFromUltimate);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(pathFromUltimate, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return pathFromUltimate;
            }
            String[] stringArray2 = new String[]{"python"};
            Path path2 = Path.of(PathManager.getHomePath(), stringArray2);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
            return path2;
        }

        @JvmStatic
        @ApiStatus.Internal
        @RequiresBackgroundThread
        @NotNull
        public final String findPathStringInHelpers(@NonNls @NotNull String resourceName) {
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            Object object = this.findPathInHelpersPossibleNull(resourceName);
            if (object == null || (object = ((Object)object.toAbsolutePath()).toString()) == null) {
                object = "";
            }
            return object;
        }

        @Deprecated(message="Use {@link PythonHelpersLocator#findPathInHelpers}.", replaceWith=@ReplaceWith(expression="findPathInHelpers(resourceName)", imports={}), level=DeprecationLevel.ERROR)
        @JvmStatic
        @NotNull
        public final String getHelperPath(@NonNls @NotNull String resourceName) {
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            return this.findPathStringInHelpers(resourceName);
        }

        static {
            $$INSTANCE = new Companion();
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(PythonHelpersLocator.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            LOG = logger;
            EP_NAME = new ExtensionPointName("com.jetbrains.python.pythonHelpersLocator");
            epNameForTests = EP_NAME;
        }
    }
}

