/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ListingState {
    AVAILABLE("available"),
    SOLD("sold"),
    CANCELLED("cancelled"),
    PENDING("pending"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ListingState> VALUE_MAP;
    private final String value;

    private ListingState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ListingState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ListingState> knownValues() {
        EnumSet<ListingState> knownValues = EnumSet.allOf(ListingState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ListingState.class, ListingState::toString);
    }
}

