﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/mgn/MgnRequest.h>
#include <aws/mgn/Mgn_EXPORTS.h>
#include <aws/mgn/model/ReplicationConfigurationDataPlaneRouting.h>
#include <aws/mgn/model/ReplicationConfigurationDefaultLargeStagingDiskType.h>
#include <aws/mgn/model/ReplicationConfigurationEbsEncryption.h>

#include <utility>

namespace Aws {
namespace mgn {
namespace Model {

/**
 */
class UpdateReplicationConfigurationTemplateRequest : public MgnRequest {
 public:
  AWS_MGN_API UpdateReplicationConfigurationTemplateRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateReplicationConfigurationTemplate"; }

  AWS_MGN_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>Update replication configuration template ARN request.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  UpdateReplicationConfigurationTemplateRequest& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Update replication configuration template associate default Application
   * Migration Service Security group request.</p>
   */
  inline bool GetAssociateDefaultSecurityGroup() const { return m_associateDefaultSecurityGroup; }
  inline bool AssociateDefaultSecurityGroupHasBeenSet() const { return m_associateDefaultSecurityGroupHasBeenSet; }
  inline void SetAssociateDefaultSecurityGroup(bool value) {
    m_associateDefaultSecurityGroupHasBeenSet = true;
    m_associateDefaultSecurityGroup = value;
  }
  inline UpdateReplicationConfigurationTemplateRequest& WithAssociateDefaultSecurityGroup(bool value) {
    SetAssociateDefaultSecurityGroup(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Update replication configuration template bandwidth throttling request.</p>
   */
  inline long long GetBandwidthThrottling() const { return m_bandwidthThrottling; }
  inline bool BandwidthThrottlingHasBeenSet() const { return m_bandwidthThrottlingHasBeenSet; }
  inline void SetBandwidthThrottling(long long value) {
    m_bandwidthThrottlingHasBeenSet = true;
    m_bandwidthThrottling = value;
  }
  inline UpdateReplicationConfigurationTemplateRequest& WithBandwidthThrottling(long long value) {
    SetBandwidthThrottling(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Update replication configuration template create Public IP request.</p>
   */
  inline bool GetCreatePublicIP() const { return m_createPublicIP; }
  inline bool CreatePublicIPHasBeenSet() const { return m_createPublicIPHasBeenSet; }
  inline void SetCreatePublicIP(bool value) {
    m_createPublicIPHasBeenSet = true;
    m_createPublicIP = value;
  }
  inline UpdateReplicationConfigurationTemplateRequest& WithCreatePublicIP(bool value) {
    SetCreatePublicIP(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Update replication configuration template data plane routing request.</p>
   */
  inline ReplicationConfigurationDataPlaneRouting GetDataPlaneRouting() const { return m_dataPlaneRouting; }
  inline bool DataPlaneRoutingHasBeenSet() const { return m_dataPlaneRoutingHasBeenSet; }
  inline void SetDataPlaneRouting(ReplicationConfigurationDataPlaneRouting value) {
    m_dataPlaneRoutingHasBeenSet = true;
    m_dataPlaneRouting = value;
  }
  inline UpdateReplicationConfigurationTemplateRequest& WithDataPlaneRouting(ReplicationConfigurationDataPlaneRouting value) {
    SetDataPlaneRouting(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Update replication configuration template use default large Staging Disk type
   * request.</p>
   */
  inline ReplicationConfigurationDefaultLargeStagingDiskType GetDefaultLargeStagingDiskType() const {
    return m_defaultLargeStagingDiskType;
  }
  inline bool DefaultLargeStagingDiskTypeHasBeenSet() const { return m_defaultLargeStagingDiskTypeHasBeenSet; }
  inline void SetDefaultLargeStagingDiskType(ReplicationConfigurationDefaultLargeStagingDiskType value) {
    m_defaultLargeStagingDiskTypeHasBeenSet = true;
    m_defaultLargeStagingDiskType = value;
  }
  inline UpdateReplicationConfigurationTemplateRequest& WithDefaultLargeStagingDiskType(
      ReplicationConfigurationDefaultLargeStagingDiskType value) {
    SetDefaultLargeStagingDiskType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Update replication configuration template EBS encryption request.</p>
   */
  inline ReplicationConfigurationEbsEncryption GetEbsEncryption() const { return m_ebsEncryption; }
  inline bool EbsEncryptionHasBeenSet() const { return m_ebsEncryptionHasBeenSet; }
  inline void SetEbsEncryption(ReplicationConfigurationEbsEncryption value) {
    m_ebsEncryptionHasBeenSet = true;
    m_ebsEncryption = value;
  }
  inline UpdateReplicationConfigurationTemplateRequest& WithEbsEncryption(ReplicationConfigurationEbsEncryption value) {
    SetEbsEncryption(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Update replication configuration template EBS encryption key ARN request.</p>
   */
  inline const Aws::String& GetEbsEncryptionKeyArn() const { return m_ebsEncryptionKeyArn; }
  inline bool EbsEncryptionKeyArnHasBeenSet() const { return m_ebsEncryptionKeyArnHasBeenSet; }
  template <typename EbsEncryptionKeyArnT = Aws::String>
  void SetEbsEncryptionKeyArn(EbsEncryptionKeyArnT&& value) {
    m_ebsEncryptionKeyArnHasBeenSet = true;
    m_ebsEncryptionKeyArn = std::forward<EbsEncryptionKeyArnT>(value);
  }
  template <typename EbsEncryptionKeyArnT = Aws::String>
  UpdateReplicationConfigurationTemplateRequest& WithEbsEncryptionKeyArn(EbsEncryptionKeyArnT&& value) {
    SetEbsEncryptionKeyArn(std::forward<EbsEncryptionKeyArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Update replication configuration template template ID request.</p>
   */
  inline const Aws::String& GetReplicationConfigurationTemplateID() const { return m_replicationConfigurationTemplateID; }
  inline bool ReplicationConfigurationTemplateIDHasBeenSet() const { return m_replicationConfigurationTemplateIDHasBeenSet; }
  template <typename ReplicationConfigurationTemplateIDT = Aws::String>
  void SetReplicationConfigurationTemplateID(ReplicationConfigurationTemplateIDT&& value) {
    m_replicationConfigurationTemplateIDHasBeenSet = true;
    m_replicationConfigurationTemplateID = std::forward<ReplicationConfigurationTemplateIDT>(value);
  }
  template <typename ReplicationConfigurationTemplateIDT = Aws::String>
  UpdateReplicationConfigurationTemplateRequest& WithReplicationConfigurationTemplateID(ReplicationConfigurationTemplateIDT&& value) {
    SetReplicationConfigurationTemplateID(std::forward<ReplicationConfigurationTemplateIDT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Update replication configuration template Replication Server instance type
   * request.</p>
   */
  inline const Aws::String& GetReplicationServerInstanceType() const { return m_replicationServerInstanceType; }
  inline bool ReplicationServerInstanceTypeHasBeenSet() const { return m_replicationServerInstanceTypeHasBeenSet; }
  template <typename ReplicationServerInstanceTypeT = Aws::String>
  void SetReplicationServerInstanceType(ReplicationServerInstanceTypeT&& value) {
    m_replicationServerInstanceTypeHasBeenSet = true;
    m_replicationServerInstanceType = std::forward<ReplicationServerInstanceTypeT>(value);
  }
  template <typename ReplicationServerInstanceTypeT = Aws::String>
  UpdateReplicationConfigurationTemplateRequest& WithReplicationServerInstanceType(ReplicationServerInstanceTypeT&& value) {
    SetReplicationServerInstanceType(std::forward<ReplicationServerInstanceTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Update replication configuration template Replication Server Security groups
   * IDs request.</p>
   */
  inline const Aws::Vector<Aws::String>& GetReplicationServersSecurityGroupsIDs() const { return m_replicationServersSecurityGroupsIDs; }
  inline bool ReplicationServersSecurityGroupsIDsHasBeenSet() const { return m_replicationServersSecurityGroupsIDsHasBeenSet; }
  template <typename ReplicationServersSecurityGroupsIDsT = Aws::Vector<Aws::String>>
  void SetReplicationServersSecurityGroupsIDs(ReplicationServersSecurityGroupsIDsT&& value) {
    m_replicationServersSecurityGroupsIDsHasBeenSet = true;
    m_replicationServersSecurityGroupsIDs = std::forward<ReplicationServersSecurityGroupsIDsT>(value);
  }
  template <typename ReplicationServersSecurityGroupsIDsT = Aws::Vector<Aws::String>>
  UpdateReplicationConfigurationTemplateRequest& WithReplicationServersSecurityGroupsIDs(ReplicationServersSecurityGroupsIDsT&& value) {
    SetReplicationServersSecurityGroupsIDs(std::forward<ReplicationServersSecurityGroupsIDsT>(value));
    return *this;
  }
  template <typename ReplicationServersSecurityGroupsIDsT = Aws::String>
  UpdateReplicationConfigurationTemplateRequest& AddReplicationServersSecurityGroupsIDs(ReplicationServersSecurityGroupsIDsT&& value) {
    m_replicationServersSecurityGroupsIDsHasBeenSet = true;
    m_replicationServersSecurityGroupsIDs.emplace_back(std::forward<ReplicationServersSecurityGroupsIDsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Update replication configuration template Staging Area subnet ID request.</p>
   */
  inline const Aws::String& GetStagingAreaSubnetId() const { return m_stagingAreaSubnetId; }
  inline bool StagingAreaSubnetIdHasBeenSet() const { return m_stagingAreaSubnetIdHasBeenSet; }
  template <typename StagingAreaSubnetIdT = Aws::String>
  void SetStagingAreaSubnetId(StagingAreaSubnetIdT&& value) {
    m_stagingAreaSubnetIdHasBeenSet = true;
    m_stagingAreaSubnetId = std::forward<StagingAreaSubnetIdT>(value);
  }
  template <typename StagingAreaSubnetIdT = Aws::String>
  UpdateReplicationConfigurationTemplateRequest& WithStagingAreaSubnetId(StagingAreaSubnetIdT&& value) {
    SetStagingAreaSubnetId(std::forward<StagingAreaSubnetIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Update replication configuration template Staging Area Tags request.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetStagingAreaTags() const { return m_stagingAreaTags; }
  inline bool StagingAreaTagsHasBeenSet() const { return m_stagingAreaTagsHasBeenSet; }
  template <typename StagingAreaTagsT = Aws::Map<Aws::String, Aws::String>>
  void SetStagingAreaTags(StagingAreaTagsT&& value) {
    m_stagingAreaTagsHasBeenSet = true;
    m_stagingAreaTags = std::forward<StagingAreaTagsT>(value);
  }
  template <typename StagingAreaTagsT = Aws::Map<Aws::String, Aws::String>>
  UpdateReplicationConfigurationTemplateRequest& WithStagingAreaTags(StagingAreaTagsT&& value) {
    SetStagingAreaTags(std::forward<StagingAreaTagsT>(value));
    return *this;
  }
  template <typename StagingAreaTagsKeyT = Aws::String, typename StagingAreaTagsValueT = Aws::String>
  UpdateReplicationConfigurationTemplateRequest& AddStagingAreaTags(StagingAreaTagsKeyT&& key, StagingAreaTagsValueT&& value) {
    m_stagingAreaTagsHasBeenSet = true;
    m_stagingAreaTags.emplace(std::forward<StagingAreaTagsKeyT>(key), std::forward<StagingAreaTagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Update replication configuration template use dedicated Replication Server
   * request.</p>
   */
  inline bool GetUseDedicatedReplicationServer() const { return m_useDedicatedReplicationServer; }
  inline bool UseDedicatedReplicationServerHasBeenSet() const { return m_useDedicatedReplicationServerHasBeenSet; }
  inline void SetUseDedicatedReplicationServer(bool value) {
    m_useDedicatedReplicationServerHasBeenSet = true;
    m_useDedicatedReplicationServer = value;
  }
  inline UpdateReplicationConfigurationTemplateRequest& WithUseDedicatedReplicationServer(bool value) {
    SetUseDedicatedReplicationServer(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Update replication configuration template use Fips Endpoint request.</p>
   */
  inline bool GetUseFipsEndpoint() const { return m_useFipsEndpoint; }
  inline bool UseFipsEndpointHasBeenSet() const { return m_useFipsEndpointHasBeenSet; }
  inline void SetUseFipsEndpoint(bool value) {
    m_useFipsEndpointHasBeenSet = true;
    m_useFipsEndpoint = value;
  }
  inline UpdateReplicationConfigurationTemplateRequest& WithUseFipsEndpoint(bool value) {
    SetUseFipsEndpoint(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;
  bool m_arnHasBeenSet = false;

  bool m_associateDefaultSecurityGroup{false};
  bool m_associateDefaultSecurityGroupHasBeenSet = false;

  long long m_bandwidthThrottling{0};
  bool m_bandwidthThrottlingHasBeenSet = false;

  bool m_createPublicIP{false};
  bool m_createPublicIPHasBeenSet = false;

  ReplicationConfigurationDataPlaneRouting m_dataPlaneRouting{ReplicationConfigurationDataPlaneRouting::NOT_SET};
  bool m_dataPlaneRoutingHasBeenSet = false;

  ReplicationConfigurationDefaultLargeStagingDiskType m_defaultLargeStagingDiskType{
      ReplicationConfigurationDefaultLargeStagingDiskType::NOT_SET};
  bool m_defaultLargeStagingDiskTypeHasBeenSet = false;

  ReplicationConfigurationEbsEncryption m_ebsEncryption{ReplicationConfigurationEbsEncryption::NOT_SET};
  bool m_ebsEncryptionHasBeenSet = false;

  Aws::String m_ebsEncryptionKeyArn;
  bool m_ebsEncryptionKeyArnHasBeenSet = false;

  Aws::String m_replicationConfigurationTemplateID;
  bool m_replicationConfigurationTemplateIDHasBeenSet = false;

  Aws::String m_replicationServerInstanceType;
  bool m_replicationServerInstanceTypeHasBeenSet = false;

  Aws::Vector<Aws::String> m_replicationServersSecurityGroupsIDs;
  bool m_replicationServersSecurityGroupsIDsHasBeenSet = false;

  Aws::String m_stagingAreaSubnetId;
  bool m_stagingAreaSubnetIdHasBeenSet = false;

  Aws::Map<Aws::String, Aws::String> m_stagingAreaTags;
  bool m_stagingAreaTagsHasBeenSet = false;

  bool m_useDedicatedReplicationServer{false};
  bool m_useDedicatedReplicationServerHasBeenSet = false;

  bool m_useFipsEndpoint{false};
  bool m_useFipsEndpointHasBeenSet = false;
};

}  // namespace Model
}  // namespace mgn
}  // namespace Aws
