﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/geo-routes/GeoRoutes_EXPORTS.h>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GeoRoutes {
namespace Model {

/**
 * <p>Price range with a minimum and maximum value, if a range.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/geo-routes-2020-11-19/RouteTollPriceValueRange">AWS
 * API Reference</a></p>
 */
class RouteTollPriceValueRange {
 public:
  AWS_GEOROUTES_API RouteTollPriceValueRange() = default;
  AWS_GEOROUTES_API RouteTollPriceValueRange(Aws::Utils::Json::JsonView jsonValue);
  AWS_GEOROUTES_API RouteTollPriceValueRange& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GEOROUTES_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Minimum price.</p>
   */
  inline double GetMin() const { return m_min; }
  inline bool MinHasBeenSet() const { return m_minHasBeenSet; }
  inline void SetMin(double value) {
    m_minHasBeenSet = true;
    m_min = value;
  }
  inline RouteTollPriceValueRange& WithMin(double value) {
    SetMin(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Maximum price.</p>
   */
  inline double GetMax() const { return m_max; }
  inline bool MaxHasBeenSet() const { return m_maxHasBeenSet; }
  inline void SetMax(double value) {
    m_maxHasBeenSet = true;
    m_max = value;
  }
  inline RouteTollPriceValueRange& WithMax(double value) {
    SetMax(value);
    return *this;
  }
  ///@}
 private:
  double m_min{0.0};
  bool m_minHasBeenSet = false;

  double m_max{0.0};
  bool m_maxHasBeenSet = false;
};

}  // namespace Model
}  // namespace GeoRoutes
}  // namespace Aws
