/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.util;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpDeserializerBase;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.DateTimeUtil;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.EnumSet;
import java.util.Locale;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DateTime
implements JsonpSerializable {
    private final long millis;
    @Nullable
    private final String str;
    @Nullable
    final DateTimeFormatter formatter;
    public static JsonpDeserializer<DateTime> _DESERIALIZER = new TimestampDeserializer();

    private DateTime(long epochMillis, String str, DateTimeFormatter format) {
        this.millis = epochMillis;
        this.str = str;
        this.formatter = format;
    }

    public static DateTime ofEpochMilli(long epochMilli, DateTimeFormatter format) {
        return new DateTime(epochMilli, null, format);
    }

    public static DateTime ofEpochMilli(long epochMilli) {
        return DateTime.ofEpochMilli(epochMilli, null);
    }

    public static DateTime of(String text) {
        return DateTime.of(text, null);
    }

    public static DateTime of(String text, DateTimeFormatter parser) {
        return new DateTime(0L, text, parser);
    }

    public static DateTime of(Temporal instant) {
        return DateTime.of(instant, null);
    }

    public static DateTime of(Temporal instant, DateTimeFormatter format) {
        long millis = instant.getLong(ChronoField.INSTANT_SECONDS) * 1000L + instant.getLong(ChronoField.MILLI_OF_SECOND);
        return new DateTime(millis, null, format);
    }

    @Nullable
    public String getString() {
        return this.str;
    }

    @Nullable
    DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    public Instant toInstant() {
        if (this.str == null) {
            return Instant.ofEpochMilli(this.millis);
        }
        if (this.formatter == null) {
            try {
                ZonedDateTime zdt = DateTimeUtil.from(DateTimeUtil.STRICT_DATE_OPTIONAL_TIME_FORMATTER.parse(this.str), Locale.ROOT, ZoneOffset.UTC);
                return zdt.toInstant();
            }
            catch (DateTimeParseException zdt) {
                try {
                    long ms = Long.parseLong(this.str);
                    return Instant.ofEpochMilli(ms);
                }
                catch (NumberFormatException nfe) {
                    throw new DateTimeParseException("Cannot parse date-time with format [strict_date_optional_time||epoch_millis]", this.str, 0);
                }
            }
        }
        return this.formatter.parse((CharSequence)this.str, Instant::from);
    }

    public Instant toInstant(DateTimeFormatter parser) {
        if (this.str == null) {
            return Instant.ofEpochMilli(this.millis);
        }
        return parser.parse((CharSequence)this.str, Instant::from);
    }

    public ZonedDateTime toZonedDateTime() {
        if (this.str == null) {
            return ZonedDateTime.ofInstant(this.toInstant(), ZoneOffset.UTC);
        }
        try {
            return DateTimeUtil.from(DateTimeUtil.STRICT_DATE_OPTIONAL_TIME_FORMATTER.parse(this.str), Locale.ROOT, ZoneOffset.UTC);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                long ms = Long.parseLong(this.str);
                return ZonedDateTime.ofInstant(Instant.ofEpochMilli(ms), ZoneOffset.UTC);
            }
            catch (NumberFormatException nfe) {
                throw new DateTimeParseException("Cannot parse date-time with format [strict_date_optional_time||epoch_millis]", this.str, 0);
            }
        }
    }

    public ZonedDateTime toZonedDateTime(DateTimeFormatter parser) {
        if (this.str == null) {
            return ZonedDateTime.ofInstant(this.toInstant(), ZoneOffset.UTC);
        }
        return parser.parse((CharSequence)this.str, ZonedDateTime::from);
    }

    public long toEpochMilli() {
        if (this.str == null) {
            return this.millis;
        }
        return this.toInstant().toEpochMilli();
    }

    public long toEpochMilli(DateTimeFormatter format) {
        if (this.str == null) {
            return this.millis;
        }
        return this.toInstant(format).toEpochMilli();
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this.str == null) {
            if (this.formatter == null) {
                generator.write(this.millis);
            } else {
                generator.write(this.formatter.format(Instant.ofEpochMilli(this.millis).atZone(ZoneOffset.UTC)));
            }
        } else {
            generator.write(this.str);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.toInstant().equals(((DateTime)o).toInstant());
    }

    public int hashCode() {
        return this.toInstant().hashCode();
    }

    public String toString() {
        if (this.str == null) {
            if (this.formatter == null) {
                return String.valueOf(this.millis);
            }
            return this.formatter.format(Instant.ofEpochMilli(this.millis).atZone(ZoneOffset.UTC));
        }
        return this.str;
    }

    private static class TimestampDeserializer
    extends JsonpDeserializerBase<DateTime> {
        TimestampDeserializer() {
            super(EnumSet.of(JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_STRING));
        }

        public DateTime deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.VALUE_NUMBER) {
                return DateTime.ofEpochMilli(parser.getLong());
            }
            return DateTime.of(parser.getString());
        }
    }
}

