/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.spi.support;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.ops4j.pax.logging.EventAdminPoster;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogLevel;
import org.osgi.util.tracker.ServiceTracker;

public class EventAdminTracker
extends ServiceTracker<EventAdmin, EventAdmin>
implements EventAdminPoster {
    private final LinkedList<Event> m_queue;
    private BundleContext m_context;
    private EventAdmin m_service;
    private int m_maxSize;

    public EventAdminTracker(BundleContext context) {
        super(context, EventAdmin.class, null);
        this.m_context = context;
        this.m_queue = new LinkedList();
        this.m_maxSize = 50;
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postEvent(Bundle bundle, LogLevel level, LogEntry entry, String message, Throwable exception, ServiceReference<?> sr, Map<String, ?> context) {
        Event event = EventAdminTracker.createEvent(bundle, level, entry, message, exception, sr, context);
        LinkedList<Event> linkedList = this.m_queue;
        synchronized (linkedList) {
            this.m_queue.add(event);
        }
        this.deliver();
        this.cleanup();
    }

    @Override
    public void destroy() {
        this.close();
    }

    public EventAdmin addingService(ServiceReference<EventAdmin> serviceReference) {
        this.m_service = (EventAdmin)this.m_context.getService(serviceReference);
        this.deliver();
        return this.m_service;
    }

    public void removedService(ServiceReference<EventAdmin> serviceReference, EventAdmin object) {
        this.m_service = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliver() {
        EventAdmin forDelivery = this.m_service;
        if (forDelivery == null) {
            return;
        }
        while (this.m_queue.size() > 0) {
            Event event = null;
            LinkedList<Event> linkedList = this.m_queue;
            synchronized (linkedList) {
                if (this.m_queue.size() > 0) {
                    event = this.m_queue.remove(0);
                }
            }
            if (event == null) continue;
            try {
                forDelivery.postEvent(event);
            }
            catch (IllegalStateException e) {
                LinkedList<Event> linkedList2 = this.m_queue;
                synchronized (linkedList2) {
                    this.m_queue.add(event);
                }
            }
        }
    }

    public int getMaxSize() {
        return this.m_maxSize;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("MaxSize must not be a negative number: " + maxSize);
        }
        if (maxSize > 1000) {
            String message = "MaxSize must not be a larger than 1000 for memory constraint reasons: " + maxSize;
            throw new IllegalArgumentException(message);
        }
        this.m_maxSize = maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        while (this.m_queue.size() > this.m_maxSize) {
            LinkedList<Event> linkedList = this.m_queue;
            synchronized (linkedList) {
                this.m_queue.remove(0);
            }
        }
    }

    static Event createEvent(Bundle bundle, LogLevel level, LogEntry entry, String message, Throwable exception, ServiceReference<?> sr, Map<String, ?> context) {
        String type;
        switch (level) {
            case AUDIT: {
                type = "LOG_AUDIT";
                break;
            }
            case ERROR: {
                type = "LOG_ERROR";
                break;
            }
            case WARN: {
                type = "LOG_WARNING";
                break;
            }
            case INFO: {
                type = "LOG_INFO";
                break;
            }
            case DEBUG: {
                type = "LOG_DEBUG";
                break;
            }
            default: {
                type = "LOG_OTHER";
            }
        }
        String topic = "org/osgi/service/log/LogEntry/" + type;
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        if (bundle != null) {
            ((Dictionary)props).put("bundle", bundle);
            Long bundleId = bundle.getBundleId();
            ((Dictionary)props).put("bundle.id", bundleId);
            String symbolicName = bundle.getSymbolicName();
            if (symbolicName != null) {
                ((Dictionary)props).put("bundle.symbolicname", symbolicName);
            }
        }
        ((Dictionary)props).put("log.level", (Object)((Object)level));
        ((Dictionary)props).put("log.entry", entry);
        if (null != message) {
            ((Dictionary)props).put("message", message);
        }
        ((Dictionary)props).put("timestamp", System.currentTimeMillis());
        if (exception != null) {
            ((Dictionary)props).put("exception", exception);
            ((Dictionary)props).put("exception.class", exception.getClass());
            if (exception.getMessage() != null) {
                ((Dictionary)props).put("exception.message", exception.getMessage());
            }
        }
        if (sr != null) {
            ((Dictionary)props).put("service", sr);
            Long id = (Long)sr.getProperty("service.id");
            ((Dictionary)props).put("service.id", id);
            String pid = (String)sr.getProperty("service.pid");
            if (pid != null) {
                ((Dictionary)props).put("service.pid", pid);
            }
            String[] objClass = (String[])sr.getProperty("objectClass");
            ((Dictionary)props).put("service.objectClass", objClass);
        }
        if (context != null) {
            for (String key : context.keySet()) {
                Object value = context.get(key);
                if (value == null) continue;
                ((Dictionary)props).put(key, value);
            }
        }
        return new Event(topic, props);
    }
}

