/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.serializer.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.UnsafeOutput;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.uniffle.common.serializer.SerOutputStream;
import org.apache.uniffle.common.serializer.SerializationStream;
import org.apache.uniffle.common.serializer.WrappedByteArrayOutputStream;
import org.apache.uniffle.common.serializer.kryo.KryoSerializerInstance;

public class KryoSerializationStream<K, V>
extends SerializationStream {
    private final KryoSerializerInstance instance;
    private SerOutputStream out;
    private WrappedByteArrayOutputStream byteStream = new WrappedByteArrayOutputStream(200);
    private Output output;
    private Kryo kryo;

    public KryoSerializationStream(KryoSerializerInstance instance, SerOutputStream out) {
        this.out = out;
        this.instance = instance;
    }

    @Override
    public void init() {
        this.output = new UnsafeOutput((OutputStream)this.byteStream);
        this.kryo = this.instance.borrowKryo();
    }

    @Override
    public void writeRecord(Object key, Object value) throws IOException {
        this.byteStream.reset();
        this.kryo.writeClassAndObject(this.output, key);
        this.kryo.writeClassAndObject(this.output, value);
        this.output.flush();
        int length = this.byteStream.size();
        this.out.preAllocate(length);
        this.out.write(this.byteStream.getBuf(), 0, length);
    }

    @Override
    public void flush() throws IOException {
        if (this.output == null) {
            throw new IOException("Stream is closed");
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.output != null) {
            try {
                this.output.close();
            }
            finally {
                this.instance.releaseKryo(this.kryo);
                this.kryo = null;
                this.output = null;
            }
        }
    }

    @Override
    public long getTotalBytesWritten() {
        return this.output.total();
    }
}

