/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shaded.org.roaringbitmap;

import java.util.function.Supplier;
import org.apache.uniffle.shaded.org.roaringbitmap.AppendableStorage;
import org.apache.uniffle.shaded.org.roaringbitmap.ArrayContainer;
import org.apache.uniffle.shaded.org.roaringbitmap.BitmapDataProvider;
import org.apache.uniffle.shaded.org.roaringbitmap.ConstantMemoryContainerAppender;
import org.apache.uniffle.shaded.org.roaringbitmap.Container;
import org.apache.uniffle.shaded.org.roaringbitmap.ContainerAppender;
import org.apache.uniffle.shaded.org.roaringbitmap.FastRankRoaringBitmap;
import org.apache.uniffle.shaded.org.roaringbitmap.RoaringArray;
import org.apache.uniffle.shaded.org.roaringbitmap.RoaringBitmap;
import org.apache.uniffle.shaded.org.roaringbitmap.RunContainer;
import org.apache.uniffle.shaded.org.roaringbitmap.WordStorage;
import org.apache.uniffle.shaded.org.roaringbitmap.buffer.MappeableArrayContainer;
import org.apache.uniffle.shaded.org.roaringbitmap.buffer.MappeableContainer;
import org.apache.uniffle.shaded.org.roaringbitmap.buffer.MappeableRunContainer;
import org.apache.uniffle.shaded.org.roaringbitmap.buffer.MutableRoaringArray;
import org.apache.uniffle.shaded.org.roaringbitmap.buffer.MutableRoaringBitmap;

public interface RoaringBitmapWriter<T extends BitmapDataProvider>
extends Supplier<T> {
    public static Wizard<Container, RoaringBitmap> writer() {
        return new RoaringBitmapWizard();
    }

    public static Wizard<MappeableContainer, MutableRoaringBitmap> bufferWriter() {
        return new BufferWizard();
    }

    public T getUnderlying();

    public void add(int var1);

    public void add(long var1, long var3);

    public void addMany(int ... var1);

    public void flush();

    @Override
    default public T get() {
        this.flush();
        return this.getUnderlying();
    }

    public void reset();

    public static class RoaringBitmapWizard
    extends RoaringWizard<RoaringBitmap> {
        @Override
        protected RoaringBitmap createUnderlying(int initialCapacity) {
            return new RoaringBitmap(new RoaringArray(initialCapacity));
        }
    }

    public static class FastRankRoaringBitmapWizard
    extends RoaringWizard<FastRankRoaringBitmap> {
        FastRankRoaringBitmapWizard(Wizard<Container, ? extends RoaringBitmap> wizard) {
            this.constantMemory = wizard.constantMemory;
            this.initialCapacity = wizard.initialCapacity;
            this.containerSupplier = wizard.containerSupplier;
            this.partiallySortValues = wizard.partiallySortValues;
        }

        @Override
        protected FastRankRoaringBitmap createUnderlying(int initialCapacity) {
            return new FastRankRoaringBitmap(new RoaringArray(initialCapacity));
        }
    }

    public static abstract class RoaringWizard<T extends RoaringBitmap>
    extends Wizard<Container, T> {
        @Override
        protected Supplier<Container> arraySupplier() {
            int size = this.expectedContainerSize;
            return () -> new ArrayContainer(size);
        }

        @Override
        protected Supplier<Container> runSupplier() {
            return RunContainer::new;
        }

        @Override
        public Wizard<Container, FastRankRoaringBitmap> fastRank() {
            return new FastRankRoaringBitmapWizard(this);
        }

        @Override
        public RoaringBitmapWriter<T> get() {
            if (this.constantMemory) {
                int capacity = this.initialCapacity;
                return new ConstantMemoryContainerAppender<RoaringBitmap>(this.partiallySortValues, this.runCompress, () -> (RoaringBitmap)this.createUnderlying(capacity));
            }
            return super.get();
        }
    }

    public static class BufferWizard
    extends Wizard<MappeableContainer, MutableRoaringBitmap> {
        @Override
        protected Supplier<MappeableContainer> arraySupplier() {
            int size = this.expectedContainerSize;
            return () -> new MappeableArrayContainer(size);
        }

        @Override
        protected Supplier<MappeableContainer> runSupplier() {
            return MappeableRunContainer::new;
        }

        @Override
        protected MutableRoaringBitmap createUnderlying(int initialCapacity) {
            return new MutableRoaringBitmap(new MutableRoaringArray(initialCapacity));
        }
    }

    public static abstract class Wizard<C extends WordStorage<C>, T extends BitmapDataProvider & AppendableStorage<C>>
    implements Supplier<RoaringBitmapWriter<T>> {
        protected int initialCapacity = 4;
        protected boolean constantMemory;
        protected boolean partiallySortValues = false;
        protected boolean runCompress = true;
        protected Supplier<C> containerSupplier = this.arraySupplier();
        protected int expectedContainerSize = 16;

        Wizard() {
        }

        public Wizard<C, T> optimiseForArrays() {
            this.containerSupplier = this.arraySupplier();
            return this;
        }

        public Wizard<C, T> optimiseForRuns() {
            this.containerSupplier = this.runSupplier();
            return this;
        }

        public Wizard<C, T> runCompress(boolean runCompress) {
            this.runCompress = runCompress;
            return this;
        }

        public Wizard<C, T> expectedValuesPerContainer(int count) {
            Wizard.sanityCheck(count);
            this.expectedContainerSize = count;
            if (count < 4096) {
                return this.optimiseForArrays();
            }
            if (count < 16384) {
                return this.constantMemory();
            }
            return this.optimiseForRuns();
        }

        public Wizard<Container, FastRankRoaringBitmap> fastRank() {
            throw new IllegalStateException("Fast rank not yet implemented for byte buffers");
        }

        public Wizard<C, T> constantMemory() {
            this.constantMemory = true;
            return this;
        }

        public Wizard<C, T> expectedDensity(double density) {
            return this.expectedValuesPerContainer((int)(65535.0 * density));
        }

        public Wizard<C, T> expectedRange(long min2, long max) {
            return this.initialCapacity((int)(max - min2 >>> 16) + 1);
        }

        public Wizard<C, T> initialCapacity(int count) {
            Wizard.sanityCheck(count);
            this.initialCapacity = count;
            return this;
        }

        public Wizard<C, T> doPartialRadixSort() {
            this.partiallySortValues = true;
            return this;
        }

        protected abstract Supplier<C> arraySupplier();

        protected abstract Supplier<C> runSupplier();

        protected abstract T createUnderlying(int var1);

        @Override
        public RoaringBitmapWriter<T> get() {
            int capacity = this.initialCapacity;
            return new ContainerAppender<C, BitmapDataProvider>(this.partiallySortValues, this.runCompress, () -> this.createUnderlying(capacity), this.containerSupplier);
        }

        private static void sanityCheck(int count) {
            if (count >= 65535) {
                throw new IllegalArgumentException(count + " > 65536");
            }
            if (count < 0) {
                throw new IllegalArgumentException(count + " < 0");
            }
        }
    }
}

