/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.rpc;

import org.apache.uniffle.common.metrics.GRPCMetrics;
import org.apache.uniffle.common.rpc.MonitoringServerCall;
import org.apache.uniffle.common.rpc.MonitoringServerCallListener;
import org.apache.uniffle.shaded.io.grpc.Metadata;
import org.apache.uniffle.shaded.io.grpc.MethodDescriptor;
import org.apache.uniffle.shaded.io.grpc.ServerCall;
import org.apache.uniffle.shaded.io.grpc.ServerCallHandler;
import org.apache.uniffle.shaded.io.grpc.ServerInterceptor;

public class MonitoringServerInterceptor
implements ServerInterceptor {
    private final GRPCMetrics grpcMetrics;

    public MonitoringServerInterceptor(GRPCMetrics grpcMetrics) {
        this.grpcMetrics = grpcMetrics;
    }

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        MethodDescriptor<ReqT, RespT> methodDescriptor = serverCall.getMethodDescriptor();
        String methodName = methodDescriptor.getBareMethodName();
        this.grpcMetrics.incCounter(methodName);
        MonitoringServerCall<ReqT, RespT> monitoringServerCall = new MonitoringServerCall<ReqT, RespT>(serverCall, methodName, this.grpcMetrics);
        return new MonitoringServerCallListener<ReqT>(serverCallHandler.startCall(monitoringServerCall, metadata));
    }
}

