/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.common;

import java.util.Objects;
import org.apache.uniffle.storage.common.ShuffleSegment;

public class FileBasedShuffleSegment
extends ShuffleSegment
implements Comparable<FileBasedShuffleSegment> {
    private static final long serialVersionUID = 0L;
    public static final int SEGMENT_SIZE = 40;
    private long offset;
    private int length;
    private int uncompressLength;
    private long crc;
    private long blockId;
    private long taskAttemptId;

    public FileBasedShuffleSegment(long blockId, long offset, int length, int uncompressLength, long crc, long taskAttemptId) {
        this.offset = offset;
        this.length = length;
        this.uncompressLength = uncompressLength;
        this.crc = crc;
        this.blockId = blockId;
        this.taskAttemptId = taskAttemptId;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public long getCrc() {
        return this.crc;
    }

    public long getBlockId() {
        return this.blockId;
    }

    public void setBlockId(long blockId) {
        this.blockId = blockId;
    }

    public int getUncompressLength() {
        return this.uncompressLength;
    }

    public long getTaskAttemptId() {
        return this.taskAttemptId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileBasedShuffleSegment that = (FileBasedShuffleSegment)o;
        return this.offset == that.offset && this.length == that.length && this.crc == that.crc && this.blockId == that.blockId && this.uncompressLength == that.uncompressLength && this.taskAttemptId == that.taskAttemptId;
    }

    @Override
    public int compareTo(FileBasedShuffleSegment fss) {
        if (this.offset > fss.getOffset()) {
            return 1;
        }
        if (this.offset < fss.getOffset()) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.length, this.uncompressLength, this.crc, this.blockId);
    }

    public String toString() {
        return "FileBasedShuffleSegment{offset[" + this.offset + "], length[" + this.length + "], uncompressLength[" + this.uncompressLength + "], crc[" + this.crc + "], blockId[" + this.blockId + "], taskAttemptId[" + this.taskAttemptId + "]}";
    }
}

