/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.uniffle.storage.handler.api.ShuffleDeleteHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileDeleteHandler
implements ShuffleDeleteHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileDeleteHandler.class);

    @Override
    public boolean delete(String[] shuffleDataStoredPath, String appId, String user) {
        String[] stringArray = shuffleDataStoredPath;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String basePath;
            String shufflePath = basePath = stringArray[i];
            long start = System.currentTimeMillis();
            try {
                File baseFolder = new File(shufflePath);
                FileUtils.deleteDirectory((File)baseFolder);
                LOG.info("Delete shuffle data for appId[" + appId + "] with " + shufflePath + " cost " + (System.currentTimeMillis() - start) + " ms");
                continue;
            }
            catch (Exception e) {
                LOG.warn("Can't delete shuffle data for appId[" + appId + "] with " + shufflePath, (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

