/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;

public class AsynDeletionEvent {
    private static final String TEMPORARYSUFFIX = "_tmp";
    private String appId;
    private String user;
    private String shuffleServerId;
    private Configuration conf;
    private Map<String, String> needDeletePathAndRenamePath;
    private String storageType;

    public AsynDeletionEvent(String appId, String user, Configuration conf, String shuffleServerId, List<String> needDeletePath, String storageType) {
        this.appId = appId;
        this.user = user;
        this.shuffleServerId = shuffleServerId;
        this.conf = conf;
        this.needDeletePathAndRenamePath = needDeletePath.stream().collect(Collectors.toMap(Function.identity(), s -> StringUtils.join((Object[])new String[]{s, TEMPORARYSUFFIX})));
        this.storageType = storageType;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getUser() {
        return this.user;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public Map<String, String> getNeedDeletePathAndRenamePath() {
        return this.needDeletePathAndRenamePath;
    }

    public String[] getNeedDeleteRenamePaths() {
        return (String[])this.needDeletePathAndRenamePath.values().stream().toArray(String[]::new);
    }

    public String getShuffleServerId() {
        return this.shuffleServerId;
    }

    public String getStorageType() {
        return this.storageType;
    }
}

