/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.buffer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBuf;
import org.apache.uniffle.shaded.io.netty.buffer.Unpooled;
import org.apache.uniffle.shaded.io.netty.channel.FileRegion;
import org.apache.uniffle.shaded.io.netty.util.CompositeFileRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiFileSegmentManagedBuffer
extends ManagedBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(MultiFileSegmentManagedBuffer.class);
    private final List<ManagedBuffer> managedBuffers;

    public MultiFileSegmentManagedBuffer(List<ManagedBuffer> managedBuffers) {
        this.managedBuffers = managedBuffers;
    }

    @Override
    public int size() {
        return this.managedBuffers.stream().mapToInt(ManagedBuffer::size).sum();
    }

    @Override
    public ByteBuf byteBuf() {
        return Unpooled.wrappedBuffer(this.nioByteBuffer());
    }

    @Override
    public ByteBuffer nioByteBuffer() {
        ByteBuffer merged = ByteBuffer.allocate(this.size());
        for (ManagedBuffer managedBuffer : this.managedBuffers) {
            ByteBuffer buffer = managedBuffer.nioByteBuffer();
            merged.put(buffer.slice());
        }
        merged.flip();
        return merged;
    }

    @Override
    public ManagedBuffer retain() {
        return this;
    }

    @Override
    public ManagedBuffer release() {
        return this;
    }

    @Override
    public Object convertToNetty() {
        ArrayList<FileRegion> fileRegions = new ArrayList<FileRegion>(this.managedBuffers.size());
        for (ManagedBuffer managedBuffer : this.managedBuffers) {
            Object object = managedBuffer.convertToNetty();
            if (!(object instanceof FileRegion)) continue;
            fileRegions.add((FileRegion)object);
        }
        return new CompositeFileRegion(fileRegions.toArray(new FileRegion[0]));
    }
}

