/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.uniffle.common.StorageType;
import org.apache.uniffle.storage.handler.impl.ShuffleServerReadCost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleServerReadCostTracker {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleServerReadCostTracker.class);
    private Map<String, ShuffleServerReadCost> tracking = new ConcurrentHashMap<String, ShuffleServerReadCost>();

    public void record(String serverId, StorageType storageType, long bytes, long durationMillis) {
        if (serverId == null) {
            return;
        }
        ShuffleServerReadCost readCost = this.tracking.computeIfAbsent(serverId, x -> new ShuffleServerReadCost((String)x));
        readCost.inc(storageType, bytes, durationMillis);
    }

    public Map<String, ShuffleServerReadCost> list() {
        return this.tracking;
    }
}

