/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.storage.api.FileWriter;
import org.apache.uniffle.storage.common.FileBasedShuffleSegment;
import org.apache.uniffle.storage.handler.api.ShuffleWriteHandler;
import org.apache.uniffle.storage.handler.impl.LocalFileWriter;
import org.apache.uniffle.storage.handler.impl.LocalFileWriterFactory;
import org.apache.uniffle.storage.util.ShuffleStorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileWriteHandler
implements ShuffleWriteHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileWriteHandler.class);
    private final RssBaseConf rssBaseConf;
    private String fileNamePrefix;
    private String basePath;
    private final int dataBufferSize;
    private final int indexBufferSize;

    public LocalFileWriteHandler(RssBaseConf rssBaseConf, String appId, int shuffleId, int startPartition, int endPartition, String storageBasePath, String fileNamePrefix) {
        this.rssBaseConf = rssBaseConf;
        this.fileNamePrefix = fileNamePrefix;
        this.basePath = ShuffleStorageUtils.getFullShuffleDataFolder(storageBasePath, ShuffleStorageUtils.getShuffleDataPath(appId, shuffleId, startPartition, endPartition));
        this.dataBufferSize = (int)this.rssBaseConf.getSizeAsBytes(RssBaseConf.RSS_STORAGE_LOCALFILE_WRITE_DATA_BUFFER_SIZE.key(), RssBaseConf.RSS_STORAGE_LOCALFILE_WRITE_DATA_BUFFER_SIZE.defaultValue());
        this.indexBufferSize = (int)this.rssBaseConf.getSizeAsBytes(RssBaseConf.RSS_STORAGE_LOCALFILE_WRITE_INDEX_BUFFER_SIZE.key(), RssBaseConf.RSS_STORAGE_LOCALFILE_WRITE_INDEX_BUFFER_SIZE.defaultValue());
        this.createBasePath();
    }

    @VisibleForTesting
    public LocalFileWriteHandler(String appId, int shuffleId, int startPartition, int endPartition, String storageBasePath, String fileNamePrefix) {
        this(new RssBaseConf(), appId, shuffleId, startPartition, endPartition, storageBasePath, fileNamePrefix);
    }

    private void createBasePath() {
        File baseFolder = new File(this.basePath);
        if (baseFolder.isDirectory()) {
            return;
        }
        try {
            Files.createDirectories(baseFolder.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RssException("Failed to create shuffle folder: " + this.basePath, e);
        }
    }

    private String pickBasePath(String[] storageBasePaths, String appId, int shuffleId, int startPartition) {
        if (storageBasePaths == null || storageBasePaths.length == 0) {
            throw new RssException("Base path can't be empty, please check rss.storage.localFile.basePaths");
        }
        int index = ShuffleStorageUtils.getStorageIndex(storageBasePaths.length, appId, shuffleId, startPartition);
        return storageBasePaths[index];
    }

    @Override
    public synchronized void write(Collection<ShufflePartitionedBlock> shuffleBlocks) throws Exception {
        File baseFolder = new File(this.basePath);
        if (!baseFolder.exists()) {
            LOG.warn("{} don't exist, the app or shuffle may be deleted", (Object)baseFolder.getAbsolutePath());
            return;
        }
        long accessTime = System.currentTimeMillis();
        String dataFileName = ShuffleStorageUtils.generateDataFileName(this.fileNamePrefix);
        String indexFileName = ShuffleStorageUtils.generateIndexFileName(this.fileNamePrefix);
        try (FileWriter dataWriter = LocalFileWriterFactory.getLocalFileWriter(this.rssBaseConf, new File(this.basePath, dataFileName), this.dataBufferSize);
             FileWriter indexWriter = this.createWriter(indexFileName, this.indexBufferSize);){
            long startTime = System.currentTimeMillis();
            for (ShufflePartitionedBlock block : shuffleBlocks) {
                long blockId = block.getBlockId();
                long crc = block.getCrc();
                long startOffset = dataWriter.nextOffset();
                dataWriter.writeData(block.getData());
                FileBasedShuffleSegment segment = new FileBasedShuffleSegment(blockId, startOffset, block.getDataLength(), block.getUncompressLength(), crc, block.getTaskAttemptId());
                indexWriter.writeIndex(segment);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Write handler write {} blocks cost {} ms without file open close", (Object)shuffleBlocks.size(), (Object)(System.currentTimeMillis() - startTime));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Write handler write {} blocks cost {} ms with file open close", (Object)shuffleBlocks.size(), (Object)(System.currentTimeMillis() - accessTime));
        }
    }

    private FileWriter createWriter(String fileName, int bufferSize) throws IOException, IllegalStateException {
        File file = new File(this.basePath, fileName);
        return new LocalFileWriter(file, bufferSize);
    }

    @VisibleForTesting
    protected String getBasePath() {
        return this.basePath;
    }
}

