/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shuffle;

import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uniffle.common.util.JavaUtils;

public class ShuffleIdMappingManager {
    private AtomicInteger shuffleIdGenerator = new AtomicInteger(-1);
    private Map<Integer, Map<String, Integer>> shuffleIdMapping = JavaUtils.newConcurrentMap();
    private Map<Integer, Boolean> shuffleDeterminateMap = JavaUtils.newConcurrentMap();

    public int createUniffleShuffleId(int shuffleId, String appShuffleIdentifier) {
        Map<String, Integer> appShuffleIdentifier2NewShuffleIdMap = this.shuffleIdMapping.get(shuffleId);
        if (appShuffleIdentifier2NewShuffleIdMap == null) {
            appShuffleIdentifier2NewShuffleIdMap = JavaUtils.newConcurrentMap();
            appShuffleIdentifier2NewShuffleIdMap.computeIfAbsent(appShuffleIdentifier, k -> this.shuffleIdGenerator.incrementAndGet());
            return appShuffleIdentifier2NewShuffleIdMap.get(appShuffleIdentifier);
        }
        return appShuffleIdentifier2NewShuffleIdMap.computeIfAbsent(appShuffleIdentifier, k -> this.shuffleIdGenerator.incrementAndGet());
    }

    public boolean hasUniffleShuffleId(int shuffleId, String appShuffleIdentifier) {
        return !this.shuffleIdMapping.isEmpty() && this.shuffleIdMapping.get(shuffleId) != null && this.shuffleIdMapping.get(shuffleId).get(appShuffleIdentifier) != null;
    }

    public int getUniffleShuffleId(int shuffleId, String appShuffleIdentifier) {
        return this.shuffleIdMapping.get(shuffleId).get(appShuffleIdentifier);
    }

    public int getUniffleShuffleIdForRead(int shuffleId) {
        return this.shuffleIdMapping.get(shuffleId).values().stream().sorted(Comparator.reverseOrder()).findFirst().get();
    }

    public void recordShuffleIdDeterminate(int shuffleId, boolean isDeterminate) {
        this.shuffleDeterminateMap.put(shuffleId, isDeterminate);
    }

    public boolean getShuffleIdDeterminate(int shuffleId) {
        return this.shuffleDeterminateMap.get(shuffleId);
    }
}

