/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.web;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.Enumeration;
import java.util.Set;
import java.util.function.Function;

public class CoalescedCollectorRegistry
extends CollectorRegistry {
    private final CollectorRegistry[] registries;

    public CoalescedCollectorRegistry(CollectorRegistry ... registries) {
        this.registries = registries;
    }

    public Enumeration<Collector.MetricFamilySamples> metricFamilySamples() {
        return new CoalescedEnumeration(index -> this.registries[index].metricFamilySamples());
    }

    public Enumeration<Collector.MetricFamilySamples> filteredMetricFamilySamples(Set<String> includedNames) {
        return new CoalescedEnumeration(index -> this.registries[index].filteredMetricFamilySamples(includedNames));
    }

    public Double getSampleValue(String name) {
        return this.getSampleValue(name, new String[0], new String[0]);
    }

    public Double getSampleValue(String name, String[] labelNames, String[] labelValues) {
        Double ret = null;
        for (CollectorRegistry collectorRegistry : this.registries) {
            ret = collectorRegistry.getSampleValue(name, labelNames, labelValues);
            if (ret == null) continue;
            return ret;
        }
        return ret;
    }

    private class CoalescedEnumeration
    implements Enumeration<Collector.MetricFamilySamples> {
        private final Function<Integer, Enumeration<Collector.MetricFamilySamples>> function;
        Enumeration<Collector.MetricFamilySamples> currentEnumeration;
        int index = 0;

        CoalescedEnumeration(Function<Integer, Enumeration<Collector.MetricFamilySamples>> function) {
            this.function = function;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.currentEnumeration == null || !this.currentEnumeration.hasMoreElements()) {
                if (this.index >= CoalescedCollectorRegistry.this.registries.length) {
                    return false;
                }
                this.currentEnumeration = this.function.apply(this.index++);
            }
            return this.currentEnumeration.hasMoreElements();
        }

        @Override
        public Collector.MetricFamilySamples nextElement() {
            if (!this.currentEnumeration.hasMoreElements()) {
                return null;
            }
            return this.currentEnumeration.nextElement();
        }
    }
}

