/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.authentication;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.apache.uima.ducc.common.authentication.AuthenticationResult;
import org.apache.uima.ducc.common.authentication.IAuthenticationResult;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.authentication.AbstractAuthenticator;

public class GSAAuthenticator
extends AbstractAuthenticator {
    private static DuccLogger duccLogger = DuccLogger.getLogger(GSAAuthenticator.class);
    private static DuccId jobid = null;
    private String version = "GSA 1.0";
    private String gsa_login = "/usr/bin/gsa_login";
    private String gsa_arg1 = "-p";
    private String gsa_response_prefix = "Successfully authenticated";

    public String getVersion() {
        return this.version;
    }

    @Override
    public String getNotes(String userid) {
        String retVal = "Specify your GSA login password.";
        return retVal;
    }

    public boolean isPasswordChecked() {
        return true;
    }

    private String get_ducc_ling() throws Exception {
        String key;
        DuccPropertiesResolver dpr = DuccPropertiesResolver.getInstance();
        String value = dpr.getFileProperty(key = "ducc.agent.launcher.ducc_spawn_path");
        if (value == null) {
            throw new Exception("missing ducc_ling in ducc.properties?");
        }
        return value;
    }

    private int login(String user, String pw) throws Exception {
        String line;
        int rc_fail;
        String location = "login";
        int rc_success = 0;
        int rc = rc_fail = 1;
        String ducc_ling = this.get_ducc_ling();
        ProcessBuilder builder = new ProcessBuilder(ducc_ling, "-u", user, "--", this.gsa_login, this.gsa_arg1);
        builder.redirectErrorStream(true);
        Process p = builder.start();
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
        w.write(pw);
        w.flush();
        w.close();
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = r.readLine()) != null) {
            duccLogger.debug(location, jobid, new Object[]{line});
            if (!line.startsWith(this.gsa_response_prefix)) continue;
            rc = rc_success;
            break;
        }
        r.close();
        return rc;
    }

    public IAuthenticationResult isAuthenticate(String userid, String domain, String password) {
        String location = "isAuthenticate";
        AuthenticationResult ar = new AuthenticationResult();
        ar.setFailure();
        try {
            int rc = this.login(userid, password);
            if (rc == 0) {
                ar.setSuccess();
            }
            duccLogger.info(location, jobid, new Object[]{"failure:" + ar.isFailure() + " success:" + ar.isSuccess()});
        }
        catch (Exception e) {
            duccLogger.warn(location, jobid, (Throwable)e, new Object[0]);
        }
        duccLogger.info(location, jobid, new Object[]{"failure:" + ar.isFailure() + " success:" + ar.isSuccess()});
        return ar;
    }
}

