/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.DuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;
import org.apache.uima.ducc.transport.event.common.history.HistoryFactory;
import org.apache.uima.ducc.transport.event.common.history.IHistoryPersistenceManager;
import org.apache.uima.ducc.ws.DuccBoot;
import org.apache.uima.ducc.ws.Info;
import org.apache.uima.ducc.ws.JobInfo;
import org.apache.uima.ducc.ws.PagingInfo;
import org.apache.uima.ducc.ws.PagingObserver;
import org.apache.uima.ducc.ws.ReservationInfo;

public class DuccData {
    private static DuccLogger logger = DuccLogger.getLogger(DuccData.class);
    private static DuccId jobid = null;
    private static DuccData instance = new DuccData();
    private volatile String published = null;
    private long slack = 100L;
    private IHistoryPersistenceManager hpm = HistoryFactory.getInstance((String)this.getClass().getName());
    private IDuccWorkMap duccWorkMap = new DuccWorkMap();
    private IDuccWorkMap duccWorkLive = new DuccWorkMap();
    private ConcurrentSkipListMap<JobInfo, JobInfo> sortedJobs = new ConcurrentSkipListMap();
    private ConcurrentSkipListMap<DuccId, JobInfo> keyMapJobs = new ConcurrentSkipListMap();
    private ConcurrentSkipListMap<ReservationInfo, ReservationInfo> sortedReservations = new ConcurrentSkipListMap();
    private ConcurrentSkipListMap<DuccId, ReservationInfo> keyMapReservations = new ConcurrentSkipListMap();
    private ConcurrentSkipListMap<JobInfo, JobInfo> sortedServices = new ConcurrentSkipListMap();
    private ConcurrentSkipListMap<DuccId, JobInfo> keyMapServices = new ConcurrentSkipListMap();
    private ConcurrentSkipListMap<Info, Info> sortedCombinedReservations = new ConcurrentSkipListMap();
    private ConcurrentSkipListMap<DuccId, Info> keyMapCombinedReservations = new ConcurrentSkipListMap();
    private PagingObserver pagingObserver = PagingObserver.getInstance();
    private boolean merge = false;

    public static void reset() {
        String location = "reset";
        logger.info(location, jobid, new Object[]{""});
        instance = new DuccData();
    }

    public static DuccData getInstance() {
        return instance;
    }

    public boolean isPublished() {
        return this.published != null;
    }

    public void setPublished() {
        this.published = TimeStamp.getCurrentMillis();
    }

    public String getPublished() {
        return this.published;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putIfNotPresent(IDuccWork duccWork) {
        DuccData duccData = this;
        synchronized (duccData) {
            DuccId duccId = duccWork.getDuccId();
            if (this.duccWorkMap.findDuccWork(duccId) == null) {
                this.duccWorkMap.addDuccWork(duccWork);
                this.updateSortedMaps(duccWork);
            }
        }
    }

    private void mergeHistory(IDuccWorkMap map) {
        String methodName = "mergeHistory";
        if (this.merge) {
            for (DuccId duccId : this.duccWorkLive.keySet()) {
                IDuccWork duccWork = this.duccWorkLive.findDuccWork(duccId);
                IDuccWorkJob history = null;
                try {
                    switch (duccWork.getDuccType()) {
                        case Job: {
                            history = this.hpm.restoreJob(duccId.getFriendly());
                            break;
                        }
                        case Reservation: {
                            history = this.hpm.restoreReservation(duccId.getFriendly());
                            break;
                        }
                        case Service: {
                            history = this.hpm.restoreService(duccId.getFriendly());
                            break;
                        }
                    }
                    if (history == null) continue;
                    map.put((Object)duccId, (Object)history);
                }
                catch (Exception e) {
                    logger.warn(methodName, duccId, new Object[]{"Cannot recover", duccWork.getDuccType(), "from history."});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(IDuccWorkMap map) {
        String location = "put";
        DuccData duccData = this;
        synchronized (duccData) {
            IDuccWorkMap mapCopy = map.deepCopy();
            this.mergeHistory(map);
            this.duccWorkLive = mapCopy;
            for (DuccId duccId : map.keySet()) {
                IDuccWork duccWork = map.findDuccWork(duccId);
                this.duccWorkMap.addDuccWork(duccWork);
                this.updateSortedMaps(duccWork);
                this.pagingObserver.put(duccWork);
                long dataTotal = 0L;
                long diffTotal = 0L;
                PagingInfo pi = this.pagingObserver.getData(duccId);
                if (pi != null) {
                    dataTotal = pi.total;
                }
                if ((pi = this.pagingObserver.getDiff(duccId)) != null) {
                    diffTotal = pi.total;
                }
                logger.debug(location, duccId, new Object[]{"dataTotal:" + dataTotal + " diffTotal:" + diffTotal});
            }
        }
        this.prune();
        this.setPublished();
    }

    private int pruneJobs() {
        String location = "pruneJobs";
        int pruned = 0;
        if ((long)this.sortedJobs.size() > DuccBoot.maxJobs + this.slack) {
            int count = 0;
            for (JobInfo jobInfo : this.sortedJobs.keySet()) {
                if (jobInfo.isOperational() || (long)(++count) <= DuccBoot.maxJobs) continue;
                DuccId duccId = jobInfo.getJob().getDuccId();
                this.sortedJobs.remove(jobInfo);
                this.keyMapJobs.remove(duccId);
                this.pagingObserver.remove(duccId);
                logger.debug(location, duccId, new Object[]{"size: " + this.sortedJobs.size()});
                ++pruned;
            }
            logger.debug(location, jobid, new Object[]{"pruned: " + pruned});
        }
        return pruned;
    }

    private int pruneReservations() {
        String location = "pruneReservations";
        int pruned = 0;
        if ((long)this.sortedReservations.size() > DuccBoot.maxReservations + this.slack) {
            int count = 0;
            for (ReservationInfo reservationInfo : this.sortedReservations.keySet()) {
                if (reservationInfo.isOperational() || (long)(++count) <= DuccBoot.maxReservations) continue;
                DuccId duccId = reservationInfo.getReservation().getDuccId();
                this.sortedReservations.remove(reservationInfo);
                this.keyMapReservations.remove(duccId);
                logger.debug(location, duccId, new Object[]{"size: " + this.sortedReservations.size()});
                ++pruned;
            }
            logger.debug(location, jobid, new Object[]{"pruned: " + pruned});
        }
        return pruned;
    }

    private int pruneServices() {
        String location = "pruneServices";
        int pruned = 0;
        if ((long)this.sortedServices.size() > DuccBoot.maxServices + this.slack) {
            int count = 0;
            for (JobInfo jobInfo : this.sortedServices.keySet()) {
                if (jobInfo.isOperational() || (long)(++count) <= DuccBoot.maxServices) continue;
                DuccId duccId = jobInfo.getJob().getDuccId();
                this.sortedServices.remove(jobInfo);
                this.keyMapServices.remove(duccId);
                logger.debug(location, duccId, new Object[]{"size: " + this.sortedServices.size()});
                ++pruned;
            }
            logger.debug(location, jobid, new Object[]{"pruned: " + pruned});
        }
        return pruned;
    }

    private int pruneCombinedReservations() {
        String location = "pruneCombinedReservations";
        int pruned = 0;
        if ((long)this.sortedCombinedReservations.size() > DuccBoot.maxReservations + this.slack) {
            int count = 0;
            for (Info info : this.sortedCombinedReservations.keySet()) {
                if (info.isOperational() || (long)(++count) <= DuccBoot.maxReservations) continue;
                DuccId duccId = info.getDuccWork().getDuccId();
                this.sortedCombinedReservations.remove(info);
                this.keyMapCombinedReservations.remove(duccId);
                logger.debug(location, duccId, new Object[]{"size: " + this.sortedCombinedReservations.size()});
                ++pruned;
            }
            logger.debug(location, jobid, new Object[]{"pruned: " + pruned});
        }
        return pruned;
    }

    public void report() {
        String location = "report";
        int jc = this.sortedJobs.size();
        int rc = this.sortedReservations.size();
        int sc = this.sortedServices.size();
        int cc = this.sortedCombinedReservations.size();
        logger.info(location, jobid, new Object[]{"" + jc + ":" + rc + ":" + sc + ":" + cc});
    }

    private void prune() {
        String location = "prune";
        int jc = this.pruneJobs();
        int rc = this.pruneReservations();
        int sc = this.pruneServices();
        int cc = this.pruneCombinedReservations();
        logger.debug(location, jobid, new Object[]{"" + jc + ":" + rc + ":" + sc + ":" + cc});
    }

    public IDuccWorkMap get() {
        return this.duccWorkMap;
    }

    public IDuccWorkMap getLive() {
        return this.duccWorkLive;
    }

    public int getJobDriverNodes() {
        String location = "getJobDriverNodes";
        int retVal = 0;
        try {
            retVal = this.duccWorkLive.getJobCount();
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private void updateJobs(IDuccWork duccWork) {
        String location = "updateJobs";
        DuccId duccId = duccWork.getDuccId();
        DuccWorkJob job = (DuccWorkJob)duccWork;
        if (this.keyMapJobs.containsKey(duccId)) {
            this.sortedJobs.remove(this.keyMapJobs.get(duccId));
            this.keyMapJobs.remove(duccId);
        }
        JobInfo jobInfo = new JobInfo(job);
        this.sortedJobs.put(jobInfo, jobInfo);
        if (!duccWork.isCompleted()) {
            this.keyMapJobs.put(duccId, jobInfo);
            logger.debug(location, duccId, new Object[]{"put job"});
        }
    }

    private void updateReservations(IDuccWork duccWork) {
        String location = "updateReservations";
        DuccId duccId = duccWork.getDuccId();
        DuccWorkReservation reservation = (DuccWorkReservation)duccWork;
        if (this.keyMapReservations.containsKey(duccId)) {
            this.sortedReservations.remove(this.keyMapReservations.get(duccId));
            this.keyMapReservations.remove(duccId);
        }
        ReservationInfo reservationInfo = new ReservationInfo(reservation);
        this.sortedReservations.put(reservationInfo, reservationInfo);
        if (!duccWork.isCompleted()) {
            this.keyMapReservations.put(duccId, reservationInfo);
            logger.debug(location, duccId, new Object[]{"put reservation"});
        }
        if (this.keyMapCombinedReservations.containsKey(duccId)) {
            this.sortedCombinedReservations.remove(this.keyMapCombinedReservations.get(duccId));
            this.keyMapCombinedReservations.remove(duccId);
        }
        Info rInfo = new Info(reservation);
        this.sortedCombinedReservations.put(rInfo, rInfo);
        if (!duccWork.isCompleted()) {
            this.keyMapCombinedReservations.put(duccId, rInfo);
            logger.debug(location, duccId, new Object[]{"put combined"});
        }
    }

    private void updateServices(IDuccWork duccWork) {
        IDuccWorkService.ServiceDeploymentType sdt;
        String location = "updateServices";
        DuccId duccId = duccWork.getDuccId();
        DuccWorkJob service = (DuccWorkJob)duccWork;
        if (this.keyMapServices.containsKey(duccId)) {
            this.sortedServices.remove(this.keyMapServices.get(duccId));
            this.keyMapServices.remove(duccId);
        }
        JobInfo serviceInfo = new JobInfo(service);
        this.sortedServices.put(serviceInfo, serviceInfo);
        if (!duccWork.isCompleted()) {
            this.keyMapServices.put(duccId, serviceInfo);
            logger.debug(location, duccId, new Object[]{"put service"});
        }
        if ((sdt = service.getServiceDeploymentType()) != null) {
            switch (sdt) {
                case other: {
                    if (this.keyMapCombinedReservations.containsKey(duccId)) {
                        this.sortedCombinedReservations.remove(this.keyMapCombinedReservations.get(duccId));
                        this.keyMapCombinedReservations.remove(duccId);
                    }
                    Info sInfo = new Info(service);
                    this.sortedCombinedReservations.put(sInfo, sInfo);
                    if (duccWork.isCompleted()) break;
                    this.keyMapCombinedReservations.put(duccId, sInfo);
                    logger.debug(location, duccId, new Object[]{"put combined"});
                    break;
                }
            }
        }
    }

    private void updateSortedMaps(IDuccWork duccWork) {
        IDuccTypes.DuccType duccType;
        if (duccWork != null && (duccType = duccWork.getDuccType()) != null) {
            switch (duccWork.getDuccType()) {
                case Job: {
                    this.updateJobs(duccWork);
                    break;
                }
                case Reservation: {
                    this.updateReservations(duccWork);
                    break;
                }
                case Service: {
                    this.updateServices(duccWork);
                    break;
                }
            }
        }
    }

    public IDuccWorkJob getJob(DuccId duccId) {
        DuccWorkJob retVal = null;
        ConcurrentSkipListMap<JobInfo, JobInfo> sortedJobs = this.getSortedJobs();
        if (sortedJobs.size() > 0) {
            Iterator<Map.Entry<JobInfo, JobInfo>> iterator = sortedJobs.entrySet().iterator();
            while (iterator.hasNext()) {
                JobInfo jobInfo = iterator.next().getValue();
                DuccWorkJob job = jobInfo.getJob();
                if (job.getDuccId().getFriendly() != duccId.getFriendly()) continue;
                retVal = job;
                break;
            }
        }
        return retVal;
    }

    public IDuccWork getReservation(DuccId duccId) {
        IDuccWork retVal = null;
        ConcurrentSkipListMap<Info, Info> sortedReservations = this.getSortedCombinedReservations();
        if (sortedReservations.size() > 0) {
            Iterator<Map.Entry<Info, Info>> iterator = sortedReservations.entrySet().iterator();
            while (iterator.hasNext()) {
                Info info = iterator.next().getValue();
                IDuccWork dw = info.getDuccWork();
                if (dw.getDuccId().getFriendly() != duccId.getFriendly()) continue;
                retVal = dw;
                break;
            }
        }
        return retVal;
    }

    private boolean isEqual(DuccId duccId, String id) {
        boolean retVal = false;
        if (duccId != null) {
            String v2;
            String v1 = duccId.getFriendly() + "";
            if (id != null && v1.equalsIgnoreCase(v2 = id)) {
                retVal = true;
            }
        }
        return retVal;
    }

    public IDuccWork getReservation(String id) {
        IDuccWork retVal = null;
        ConcurrentSkipListMap<Info, Info> sortedReservations = this.getSortedCombinedReservations();
        if (sortedReservations.size() > 0) {
            Iterator<Map.Entry<Info, Info>> iterator = sortedReservations.entrySet().iterator();
            while (iterator.hasNext()) {
                Info info = iterator.next().getValue();
                IDuccWork dw = info.getDuccWork();
                if (!this.isEqual(dw.getDuccId(), id)) continue;
                retVal = dw;
                break;
            }
        }
        return retVal;
    }

    public ConcurrentSkipListMap<JobInfo, JobInfo> getSortedJobs() {
        return this.sortedJobs;
    }

    public ConcurrentSkipListMap<ReservationInfo, ReservationInfo> getSortedReservations() {
        return this.sortedReservations;
    }

    public ConcurrentSkipListMap<JobInfo, JobInfo> getSortedServices() {
        return this.sortedServices;
    }

    public ConcurrentSkipListMap<Info, Info> getSortedCombinedReservations() {
        return this.sortedCombinedReservations;
    }

    public boolean isLive(DuccId duccId) {
        return this.duccWorkLive.containsKey((Object)duccId);
    }
}

