/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.sm;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.ducc.common.IServiceStatistics;
import org.apache.uima.ducc.transport.event.common.IDuccState;
import org.apache.uima.ducc.transport.event.sm.IService;
import org.apache.uima.ducc.transport.event.sm.IServiceDescription;

public class ServiceDescription
implements IServiceDescription {
    private static final long serialVersionUID = 1L;
    private Long[] implementors;
    private Integer[] instance_ids;
    private Long[] references;
    private IService.ServiceType type;
    private IService.ServiceClass subclass;
    private String endpoint;
    private String broker;
    private IService.ServiceState serviceState = IService.ServiceState.Undefined;
    private IDuccState.JobState jobState;
    private boolean active;
    private boolean autostart = true;
    private boolean enabled = true;
    private String disable_reason = null;
    private Long id;
    private String user;
    private boolean deregistered;
    private int instances;
    private long linger;
    private Map<String, String> dependencies;
    private IServiceStatistics qstats;
    private String error_string = null;
    private long last_use = 0L;
    private long last_ping = 0L;
    private long last_runnable = 0L;
    private String registration_date = null;
    private boolean reference_start = true;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public Long[] getImplementors() {
        return this.implementors;
    }

    @Override
    public Integer[] getInstanceIds() {
        return this.instance_ids;
    }

    @Override
    public void setImplementors(ArrayList<Long> implementors, ArrayList<Integer> instance_ids) {
        this.implementors = implementors.toArray(new Long[implementors.size()]);
        this.instance_ids = instance_ids.toArray(new Integer[instance_ids.size()]);
    }

    @Override
    public Long[] getReferences() {
        return this.references;
    }

    @Override
    public void setReferences(ArrayList<Long> references) {
        this.references = references.toArray(new Long[references.size()]);
    }

    @Override
    public IService.ServiceType getType() {
        return this.type;
    }

    @Override
    public void setType(IService.ServiceType type) {
        this.type = type;
    }

    @Override
    public IService.ServiceClass getSubclass() {
        return this.subclass;
    }

    @Override
    public void setSubclass(IService.ServiceClass subclass) {
        this.subclass = subclass;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public String getBroker() {
        return this.broker;
    }

    @Override
    public void setBroker(String broker) {
        this.broker = broker;
    }

    @Override
    public IService.ServiceState getServiceState() {
        return this.serviceState;
    }

    @Override
    public void setServiceState(IService.ServiceState serviceState) {
        this.serviceState = serviceState;
    }

    @Override
    public IDuccState.JobState getJobState() {
        return this.jobState;
    }

    @Override
    public void setJobState(IDuccState.JobState jobState) {
        this.jobState = jobState;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public void setDeregistered(boolean d) {
        this.deregistered = d;
    }

    @Override
    public void setQueueStatistics(IServiceStatistics qstats) {
        this.qstats = qstats;
    }

    @Override
    public IServiceStatistics getQueueStatistics() {
        return this.qstats;
    }

    @Override
    public boolean isAutostart() {
        return this.autostart;
    }

    @Override
    public void setAutostart(boolean autostart) {
        this.autostart = autostart;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getDisableReason() {
        return this.disable_reason;
    }

    @Override
    public void setDisableReason(String s) {
        this.disable_reason = s;
    }

    @Override
    public void setErrorString(String s) {
        this.error_string = s;
    }

    @Override
    public String getErrorString() {
        return this.error_string;
    }

    @Override
    public void setLastUse(long l) {
        this.last_use = l;
    }

    @Override
    public long getLastUse() {
        return this.last_use;
    }

    @Override
    public String getLastUseString() {
        if (this.last_use == 0L) {
            return "N/A";
        }
        return new Date(this.last_use).toString();
    }

    @Override
    public void setLastPing(long l) {
        this.last_ping = l;
    }

    @Override
    public long getLastPing() {
        return this.last_ping;
    }

    @Override
    public String getLastPingString() {
        if (this.last_ping == 0L) {
            return "N/A";
        }
        return new Date(this.last_ping).toString();
    }

    @Override
    public void setLastRunnable(long l) {
        this.last_runnable = l;
    }

    @Override
    public long getLastRunnable() {
        return this.last_runnable;
    }

    @Override
    public String getLastRunnableString() {
        if (this.last_runnable == 0L) {
            return "N/A";
        }
        return new Date(this.last_runnable).toString();
    }

    @Override
    public void setRegistrationDate(String s) {
        this.registration_date = s;
    }

    @Override
    public String getRegistrationDate() {
        return this.registration_date;
    }

    @Override
    public void setReferenceStart(boolean b) {
        this.reference_start = b;
    }

    @Override
    public boolean isReferenceStart() {
        return this.reference_start;
    }

    @Override
    public IServiceStatistics getQstats() {
        return this.qstats;
    }

    @Override
    public void setQstats(IServiceStatistics qstats) {
        this.qstats = qstats;
    }

    @Override
    public boolean isDeregistered() {
        return this.deregistered;
    }

    @Override
    public void setInstances(int instances) {
        this.instances = instances;
    }

    @Override
    public int getInstances() {
        return this.instances;
    }

    @Override
    public void setLinger(long linger) {
        this.linger = linger;
    }

    @Override
    public long getLinger() {
        return this.linger;
    }

    @Override
    public void addDependency(String endpoint, String msg) {
        if (this.dependencies == null) {
            this.dependencies = new HashMap<String, String>();
        }
        this.dependencies.put(endpoint, msg);
    }

    @Override
    public Map<String, String> getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Service: ");
        sb.append(this.type.decode());
        sb.append(":");
        sb.append(this.endpoint);
        if (this.type == IService.ServiceType.UimaAs) {
            sb.append(":");
            sb.append(this.broker);
        }
        sb.append("\n");
        sb.append("   Service Class     : ");
        sb.append(this.subclass.decode());
        switch (this.subclass) {
            case Registered: {
                sb.append(" as ID ");
                sb.append(this.id);
                sb.append(" Owner[");
                sb.append(this.user);
                sb.append("] instances[");
                sb.append(Integer.toString(this.instances));
                sb.append("] linger[");
                sb.append(Long.toString(this.linger));
                sb.append("]");
                break;
            }
        }
        sb.append("\n");
        sb.append("   Implementors      : ");
        if (this.implementors.length > 0) {
            for (int i = 0; i < this.implementors.length; ++i) {
                sb.append(this.implementors[i]);
                sb.append(".");
                sb.append(this.instance_ids[i]);
                sb.append(" ");
            }
        } else {
            sb.append("(N/A)");
        }
        sb.append("\n");
        sb.append("   References        : ");
        if (this.references.length > 0) {
            for (Long id : this.references) {
                sb.append(id);
                sb.append(" ");
            }
        } else {
            sb.append("None");
        }
        sb.append("\n");
        sb.append("   Dependencies      : ");
        if (this.dependencies == null) {
            sb.append("none\n");
        } else {
            sb.append("\n");
            for (String s : this.dependencies.keySet()) {
                sb.append("      ");
                sb.append(s);
                sb.append(": ");
                sb.append(this.dependencies.get(s));
                sb.append("\n");
            }
        }
        sb.append("   Service State     : ");
        sb.append((Object)this.serviceState);
        sb.append("\n");
        sb.append("   Ping Active       : ");
        sb.append(this.active);
        sb.append("\n");
        sb.append("   Start Mode        : ");
        if (this.autostart) {
            sb.append("autostart");
        } else if (this.reference_start) {
            sb.append("reference");
        } else if (this.implementors.length > 0) {
            sb.append("manual");
        } else {
            sb.append("stopped");
        }
        if (this.enabled) {
            sb.append(", Enabled");
        } else {
            sb.append(", Disabled; reason: ");
            sb.append(this.disable_reason);
        }
        sb.append("\n");
        sb.append("   Last Use          : ");
        sb.append(this.getLastUseString());
        sb.append("\n");
        sb.append("   Last Ping         : ");
        sb.append(this.getLastPingString());
        sb.append("\n");
        sb.append("   Last Runnable     : ");
        sb.append(this.getLastRunnableString());
        sb.append("\n");
        sb.append("   Registration Date : ");
        sb.append(this.registration_date);
        sb.append("\n");
        if (this.error_string != null) {
            sb.append("   Errors            : ");
            sb.append(this.error_string);
            sb.append("\n");
        }
        sb.append("   Service Statistics: ");
        if (this.qstats == null) {
            sb.append("None\n");
        } else {
            sb.append("\n       ");
            sb.append(this.qstats.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

