/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.common;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.ducc.container.jd.mh.iface.IProcessInfo;
import org.apache.uima.ducc.transport.event.common.IDuccProcessWorkItems;

public class DuccProcessWorkItems
implements IDuccProcessWorkItems {
    private static final long serialVersionUID = 1L;
    private AtomicLong dispatch = new AtomicLong(0L);
    private AtomicLong done = new AtomicLong(0L);
    private AtomicLong error = new AtomicLong(0L);
    private AtomicLong retry = new AtomicLong(0L);
    private AtomicLong preempt = new AtomicLong(0L);
    private AtomicLong doneMillisAvg = new AtomicLong(0L);
    private AtomicLong doneMillisMax = new AtomicLong(0L);
    private AtomicLong doneMillisMin = new AtomicLong(0L);

    public DuccProcessWorkItems() {
    }

    public DuccProcessWorkItems(IProcessInfo pi) {
        this.dispatch.set(pi.getDispatch());
        this.done.set(pi.getDone());
        this.error.set(pi.getError());
        this.retry.set(pi.getRetry());
        this.preempt.set(pi.getPreempt());
        this.doneMillisAvg.set(pi.getAvg());
        this.doneMillisMax.set(pi.getMax());
        this.doneMillisMin.set(pi.getMin());
    }

    @Override
    public boolean isAssignedWork() {
        boolean retVal = true;
        if (this.getCountDispatch() == 0L && this.getCountDone() == 0L && this.getCountError() == 0L && this.getCountPreempt() == 0L && this.getCountRetry() == 0L) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    public boolean isActiveWork() {
        boolean retVal = true;
        if (this.getCountDispatch() == 0L) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    public void setCountDispatch(long value) {
        this.dispatch.set(value);
    }

    @Override
    public void setCountDone(long value) {
        this.done.set(value);
    }

    @Override
    public void setCountError(long value) {
        this.error.set(value);
    }

    @Override
    public void setCountRetry(long value) {
        this.retry.set(value);
    }

    @Override
    public void setCountPreempt(long value) {
        this.preempt.set(value);
    }

    @Override
    public long getCountDispatch() {
        return this.dispatch.get();
    }

    @Override
    public long getCountDone() {
        return this.done.get();
    }

    @Override
    public long getCountError() {
        return this.error.get();
    }

    @Override
    public long getCountRetry() {
        return this.retry.get();
    }

    @Override
    public long getCountPreempt() {
        return this.preempt.get();
    }

    @Override
    public void setMillisAvg(long value) {
        this.doneMillisAvg.set(value);
    }

    @Override
    public void setMillisMax(long value) {
        this.doneMillisMax.set(value);
    }

    @Override
    public void setMillisMin(long value) {
        this.doneMillisMin.set(value);
    }

    @Override
    public long getMillisAvg() {
        long retVal = 0L;
        try {
            retVal = this.doneMillisAvg.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public long getMillisMax() {
        long retVal = 0L;
        try {
            retVal = this.doneMillisMax.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public long getMillisMin() {
        long retVal = 0L;
        try {
            retVal = this.doneMillisMin.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public long getSecsAvg() {
        double retVal = 0.0;
        try {
            retVal = (double)this.doneMillisAvg.get() / 1000.0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (long)retVal;
    }

    @Override
    public long getSecsMax() {
        double retVal = 0.0;
        try {
            retVal = (double)this.doneMillisMax.get() / 1000.0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (long)retVal;
    }

    @Override
    public long getSecsMin() {
        double retVal = 0.0;
        try {
            retVal = (double)this.doneMillisMin.get() / 1000.0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (long)retVal;
    }
}

