/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.dispatcher;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class ClassManager {
    private boolean DEBUG = false;
    private String DUCC_HOME = System.getProperty("DUCC_HOME");
    private URL[] urls = null;
    private ClassLoader classloader = null;
    private String[] private_classpath;
    private int level = 0;

    public ClassManager(String[] cp) throws Exception {
        if (this.DUCC_HOME == null) {
            throw new IllegalStateException("Internal error: DUCC_HOME must be set as a system property.");
        }
        this.private_classpath = cp;
        this.make_urls();
        HttpClassLoader top = new HttpClassLoader(this.urls, ClassLoader.getSystemClassLoader().getParent());
        this.classloader = new PrivateClassLoader(this.getClass().getClassLoader(), top);
        Thread.currentThread().setContextClassLoader(this.classloader);
        if (this.DEBUG) {
            System.out.println("Context class loader set to " + this.classloader);
        }
    }

    private void expand_wildcards(List<URL> in, String cp_entry) throws Exception {
        String path = this.DUCC_HOME + "/" + cp_entry;
        if (!path.endsWith("*")) {
            File f = new File(path);
            if (!f.exists()) {
                throw new IllegalStateException("Internal error: cannot find private classpath entry " + path);
            }
            if (f.isFile()) {
                in.add(f.toURI().toURL());
            } else if (f.isDirectory()) {
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                in.add(f.toURI().toURL());
            }
            return;
        }
        cp_entry = cp_entry.substring(0, cp_entry.length() - 1);
        int ndx = path.lastIndexOf("/");
        String p = path.substring(0, ndx);
        File parent = new File(p);
        if (parent.isDirectory()) {
            File[] contents;
            for (File f : contents = parent.listFiles()) {
                if (f.isDirectory() || !f.toString().contains(cp_entry)) continue;
                in.add(f.toURI().toURL());
            }
        } else {
            throw new Exception("Internal error: cannot find private classpath directory " + parent);
        }
    }

    private void make_urls() throws Exception {
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (String elem : this.private_classpath) {
            this.expand_wildcards(urlList, elem);
        }
        this.urls = urlList.toArray(new URL[urlList.size()]);
    }

    private void listLoaders(ClassLoader cl) {
        System.out.println("Loader at level " + this.level + " is " + cl);
        if (cl.getParent() != null) {
            ++this.level;
            this.listLoaders(cl.getParent());
        }
    }

    public Class<?> loadClass(String name) throws MalformedURLException, ClassNotFoundException {
        if (this.DEBUG) {
            System.out.println("app_loader");
            this.level = 0;
            this.listLoaders(this.classloader);
        }
        Thread.currentThread().setContextClassLoader(this.classloader);
        if (this.DEBUG) {
            System.out.println("app_loader is " + this.classloader);
            System.out.println("My loader is " + this.getClass().getClassLoader());
            System.out.println("System class loader is " + ClassLoader.getSystemClassLoader());
            this.level = 0;
            this.listLoaders(this.classloader);
        }
        return Class.forName(name, true, this.classloader);
    }

    private boolean argumentsMatch(Class<?>[] cparms, Object[] args) {
        if (cparms.length != args.length) {
            return false;
        }
        for (int i = 0; i < cparms.length; ++i) {
            Class<?> cl = null;
            cl = args[i] == null ? null : args[i].getClass();
            if (!cparms[i].isPrimitive() && cl == null) continue;
            if (!cparms[i].isAssignableFrom(cl)) {
                return false;
            }
            Class<?>[] declared = cl.getClasses();
            for (int j = 0; j < declared.length; ++j) {
                if (this.DEBUG) {
                    System.out.println("Check argument match cparms: " + cparms[i] + " with " + declared[j]);
                }
                if (!cparms[i].isAssignableFrom(declared[j])) continue;
                return true;
            }
        }
        return true;
    }

    public Object construct(String name, Object[] args) throws Exception {
        Constructor<?>[] allConstructors;
        Class<?> cls = this.loadClass(name);
        if (this.DEBUG) {
            System.out.println("Context class loader: " + Thread.currentThread().getContextClassLoader());
        }
        Constructor<?> cons = null;
        for (Constructor<?> c : allConstructors = cls.getConstructors()) {
            if (this.DEBUG) {
                System.out.println("Constructor for " + name + " : " + c);
            }
            Class<?>[] cparms = c.getParameterTypes();
            if (this.DEBUG) {
                for (Class<?> cc : cparms) {
                    System.out.println("   takes parameter " + cc.getName() + " : from " + cc.getClassLoader());
                }
            }
            if (cparms.length != args.length) {
                if (!this.DEBUG) continue;
                System.out.println("Constructor " + c + " is not viable because argument length differs.");
                continue;
            }
            if (!this.argumentsMatch(cparms, args)) continue;
            cons = c;
            break;
        }
        if (cons == null) {
            throw new ClassNotFoundException(name + " has no compatible arguments.");
        }
        if (this.DEBUG) {
            System.out.println("Use constructor " + cons);
        }
        Object o = cons.newInstance(args);
        return o;
    }

    public Object construct(String name) throws Exception {
        Class<?> cls = this.loadClass(name);
        if (this.DEBUG) {
            System.out.println("Context class loader: " + Thread.currentThread().getContextClassLoader());
        }
        return cls.newInstance();
    }

    public Object invoke(Object obj, String meth) throws Exception {
        return this.invoke(obj, meth, null);
    }

    public Object invoke(Object obj, String meth, Object[] args) throws Exception {
        Method m = null;
        if (args != null) {
            Method[] methods;
            for (Method mm : methods = obj.getClass().getMethods()) {
                Class<?>[] cparms;
                if (!mm.getName().equals(meth) || !this.argumentsMatch(cparms = mm.getParameterTypes(), args)) continue;
                m = mm;
                break;
            }
            if (m == null) {
                throw new NoSuchMethodException(meth);
            }
        } else {
            m = obj.getClass().getMethod(meth, new Class[0]);
        }
        Object ret = m.invoke(obj, args);
        return ret;
    }

    public Object invokex(Object obj, String meth, Object[] args) throws Exception {
        Method m;
        if (args != null) {
            Class[] cl_args = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                cl_args[i] = args[i].getClass();
            }
            m = obj.getClass().getMethod(meth, cl_args);
        } else {
            m = obj.getClass().getMethod(meth, new Class[0]);
        }
        Object ret = m.invoke(obj, args);
        return ret;
    }

    void invokeStatic(String cls, String meth, Object[] args) throws Exception {
        Class<?> cl = this.loadClass(cls);
        Class[] cl_args = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            cl_args[i] = args[i].getClass();
        }
        Method m = cl.getMethod(meth, cl_args);
        m.invoke(null, args);
    }

    class PrivateClassLoader
    extends ClassLoader {
        ClassLoader parent;
        HttpClassLoader grand_parent;

        PrivateClassLoader(ClassLoader parent, HttpClassLoader grand_parent) {
            super(parent);
            this.parent = parent;
            this.grand_parent = grand_parent;
        }

        @Override
        public Class<?> loadClass(String clname, boolean resolve) throws ClassNotFoundException {
            Class<?> ret = null;
            if (ClassManager.this.DEBUG) {
                System.out.println("---- A ------- load class " + clname + " from " + this);
            }
            try {
                ret = this.grand_parent.loadClass(clname, resolve);
                if (ClassManager.this.DEBUG) {
                    System.out.println("---- A ------- returns " + clname + " from " + this.grand_parent);
                }
                return ret;
            }
            catch (ClassNotFoundException e) {
                if (ClassManager.this.DEBUG) {
                    System.out.println("---- A ------- looking in " + this.parent + " to load " + clname);
                }
                ret = super.loadClass(clname, resolve);
                if (ClassManager.this.DEBUG) {
                    System.out.println("---- A ------- returns " + clname + " from " + this.parent);
                }
                return ret;
            }
        }
    }

    class HttpClassLoader
    extends URLClassLoader {
        HttpClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public Class<?> loadClass(String clname, boolean resolve) throws ClassNotFoundException {
            if (ClassManager.this.DEBUG) {
                System.out.println("--------- HttpClassLoader ------- load class " + clname);
            }
            try {
                Class<?> ret = super.loadClass(clname, resolve);
                if (ClassManager.this.DEBUG) {
                    System.out.println("--------- HttpClassLoader ------- returns " + clname);
                }
                return ret;
            }
            catch (ClassNotFoundException e) {
                if (ClassManager.this.DEBUG) {
                    System.out.println("--------- HttpClassLoader ------- fails to find " + clname);
                }
                throw e;
            }
        }
    }
}

