/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.sd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.ducc.container.sd.ServiceRegistry;

public class ServiceRegistry_impl
implements ServiceRegistry {
    Map<String, Map<String, String>> serviceNameMap = new HashMap<String, Map<String, String>>();
    Map<String, String> serviceMap;
    private File registryDir;
    private static ServiceRegistry instance = new ServiceRegistry_impl();
    static String[] badChars = new String[]{"%", "%25", "/", "%2F"};

    public static ServiceRegistry getInstance() {
        return instance;
    }

    @Override
    public boolean initialize(String location) {
        this.registryDir = new File(location);
        if (!this.registryDir.exists()) {
            this.registryDir.mkdir();
        }
        return this.registryDir.canWrite();
    }

    @Override
    public String register(String name, String address, String details) {
        Throwable throwable;
        File instanceFile;
        String prevDetails = null;
        File serviceDir = new File(this.registryDir, this.encode(name));
        if (!serviceDir.exists()) {
            serviceDir.mkdir();
        }
        if ((instanceFile = new File(serviceDir, this.encode(address))).exists()) {
            try {
                throwable = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(instanceFile));){
                    prevDetails = reader.readLine();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                System.err.println("ERROR: Failed to read previous details when updating registry file: " + instanceFile.getAbsolutePath() + " - " + e);
                prevDetails = e.toString();
            }
        }
        try {
            throwable = null;
            try (PrintWriter writer = new PrintWriter(instanceFile);){
                writer.println(details);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("ERROR: Failed to create registry file: " + instanceFile.getAbsolutePath() + " - " + e);
        }
        Runtime.getRuntime().addShutdownHook(new UnregisterHook(this, name, address));
        return prevDetails;
    }

    @Override
    public synchronized String fetch(String name) {
        File serviceDir = new File(this.registryDir, this.encode(name));
        File[] files;
        while (!serviceDir.exists() || (files = serviceDir.listFiles()).length <= 0) {
            try {
                System.out.println("!! fetch will try " + name + " again in 15 secs");
                Thread.sleep(15000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return this.decode(files[0].getName());
    }

    @Override
    public String[][] query(String name) {
        File serviceDir = new File(this.registryDir, this.encode(name));
        if (!serviceDir.exists()) {
            return new String[0][];
        }
        File[] files = serviceDir.listFiles();
        String[][] addrs = new String[files.length][];
        for (int i = 0; i < addrs.length; ++i) {
            String details;
            try (BufferedReader reader = new BufferedReader(new FileReader(files[i]));){
                details = reader.readLine();
            }
            catch (IOException e) {
                details = "ERROR: Failed to read instanceId from registry file: " + files[i].getAbsolutePath() + " - " + e;
            }
            String[] adPair = new String[]{this.decode(files[i].getName()), details};
            addrs[i] = adPair;
        }
        return addrs;
    }

    @Override
    public boolean unregister(String name, String address) {
        File instanceFile;
        File serviceDir = new File(this.registryDir, this.encode(name));
        if (serviceDir.exists() && (instanceFile = new File(serviceDir, this.encode(address))).exists()) {
            instanceFile.delete();
            if (serviceDir.list().length == 0) {
                serviceDir.delete();
            }
            return true;
        }
        return false;
    }

    private String encode(String name) {
        for (int i = 0; i < badChars.length; i += 2) {
            name = name.replaceAll(badChars[i], badChars[i + 1]);
        }
        return name;
    }

    private String decode(String name) {
        for (int i = 0; i < badChars.length; i += 2) {
            name = name.replaceAll(badChars[i + 1], badChars[i]);
        }
        return name;
    }

    public static void main(String[] args) throws InterruptedException {
        if (args.length != 3) {
            System.out.println("Usage: service-name address-prefix num");
            return;
        }
        String name = args[0];
        ServiceRegistry reg = ServiceRegistry_impl.getInstance();
        String[][] addrs = reg.query(name);
        System.out.println("Service " + name + " has " + addrs.length + " instances");
        int num = Integer.valueOf(args[2]);
        for (int i = 0; i < num; ++i) {
            reg.register(name, args[1] + i, "100" + i);
            addrs = reg.query(name);
            System.out.println("Service " + args[0] + " has " + addrs.length + " instances");
            for (String[] addrDetails : addrs) {
                System.out.println("   addr: " + addrDetails[0] + " details: " + addrDetails[1]);
            }
        }
        String address = reg.fetch(name);
        System.out.println("fetch returned: " + address);
        System.out.println("Sleeping for 30 secs");
        Thread.sleep(30000L);
        for (int i = 1; i < num + 1; ++i) {
            String addr = args[1] + i;
            boolean ok = reg.unregister(name, addr);
            System.out.println("Unregistered " + addr + " was " + ok);
        }
        address = reg.fetch(name);
        System.out.println("fetch returned: " + address);
        String addr = args[1] + 0;
        reg.unregister(name, addr);
        address = reg.fetch(name);
        System.out.println("fetch returned: " + address);
    }

    private class UnregisterHook
    extends Thread {
        private ServiceRegistry registry;
        private String name;
        private String address;

        UnregisterHook(ServiceRegistry registry, String name, String address) {
            this.registry = registry;
            this.name = name;
            this.address = address;
        }

        @Override
        public void run() {
            this.registry.unregister(this.name, this.address);
            System.out.println("!! Unregistered " + this.address + " in shotdown hook");
        }
    }
}

