/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.error.handler;

import java.net.ConnectException;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.controller.PrimitiveAnalysisEngineController;
import org.apache.uima.aae.delegate.Delegate;
import org.apache.uima.aae.error.ErrorContext;
import org.apache.uima.aae.error.ErrorHandler;
import org.apache.uima.aae.error.ErrorHandlerBase;
import org.apache.uima.aae.error.Threshold;
import org.apache.uima.util.Level;

public class GetMetaErrorHandler
extends ErrorHandlerBase
implements ErrorHandler {
    private static final Class CLASS_NAME = GetMetaErrorHandler.class;
    private Map delegateMap = null;

    public GetMetaErrorHandler(Map aDelegateMap) {
        this.delegateMap = aDelegateMap;
    }

    @Override
    public Map getEndpointThresholdMap() {
        return this.delegateMap;
    }

    private boolean terminate(Threshold aThreshold) {
        return aThreshold == null || aThreshold.getAction() == null || aThreshold.getAction().trim().length() == 0 || "Terminate".equalsIgnoreCase(aThreshold.getAction());
    }

    private boolean isConnectionFailure(Exception e) {
        return e != null && e.getCause() != null && e.getCause() instanceof ConnectException;
    }

    @Override
    public boolean handleError(Throwable t, ErrorContext anErrorContext, AnalysisEngineController aController) {
        Endpoint endpoint;
        if (aController instanceof PrimitiveAnalysisEngineController || !this.isHandlerForError(anErrorContext, 2001)) {
            return false;
        }
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
            if (aController != null) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleError", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)aController.getComponentName());
            }
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAEE_exception__WARNING", t);
        }
        if ((endpoint = (Endpoint)anErrorContext.get("Endpoint")) != null && aController instanceof AggregateAnalysisEngineController) {
            Threshold threshold = super.getThreshold(endpoint, this.delegateMap, aController);
            String key = ((AggregateAnalysisEngineController)aController).lookUpDelegateKey(endpoint.getEndpoint());
            Delegate delegate = ((AggregateAnalysisEngineController)aController).lookupDelegate(key);
            if (delegate != null && delegate.isAwaitingPingReply() || threshold == null || threshold.getMaxRetries() == 0 || !super.retryLastCommand(2001, endpoint, aController, key, threshold, anErrorContext)) {
                if (this.terminate(threshold)) {
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "handleError", "uimaee_messages", "UIMAEE_terminate_service__INFO", new Object[]{aController.getComponentName(), endpoint.getEndpoint()});
                    }
                    aController.terminate();
                    if (delegate != null && !delegate.isAwaitingPingReply() && t instanceof Exception) {
                        aController.notifyListenersWithInitializationStatus((Exception)t);
                    }
                } else {
                    aController.takeAction(threshold.getAction(), endpoint.getEndpoint(), anErrorContext);
                }
            }
        } else if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAEE_no_endpoint_for_getmeta_retry__INFO", new Object[]{aController.getName()});
        }
        return true;
    }

    public static void main(String[] args) {
    }
}

