/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.user.common;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static String resolvePlaceholders(String contents) {
        return Utils.resolvePlaceholders(contents, System.getProperties());
    }

    public static String resolvePlaceholders(String contents, Properties props) {
        Pattern placeHolderPattern = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher matcher = placeHolderPattern.matcher(contents);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(1);
            String placeholderValue = props.getProperty(key);
            if (placeholderValue == null && (placeholderValue = System.getProperty(key)) == null) {
                throw new IllegalArgumentException("Missing value for placeholder: " + key);
            }
            matcher.appendReplacement(sb, placeholderValue);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String resolvePlaceholderIfExists(String value, Properties props) {
        String retVal = value;
        if (value != null && value.contains("${")) {
            retVal = Utils.resolvePlaceholders(value, props);
        }
        return retVal;
    }
}

