/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.jd.scheduler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.SizeBytes;
import org.apache.uima.ducc.common.db.DbQuery;
import org.apache.uima.ducc.common.db.IDbMachine;
import org.apache.uima.ducc.common.head.IDuccHead;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.DuccHead;
import org.apache.uima.ducc.orchestrator.OrchestratorCommonArea;
import org.apache.uima.ducc.orchestrator.ReservationFactory;
import org.apache.uima.ducc.orchestrator.StateManager;
import org.apache.uima.ducc.orchestrator.WorkMapHelper;
import org.apache.uima.ducc.orchestrator.ckpt.OrchestratorCheckpoint;
import org.apache.uima.ducc.orchestrator.jd.scheduler.JdHelper;
import org.apache.uima.ducc.orchestrator.jd.scheduler.JdHostProperties;
import org.apache.uima.ducc.orchestrator.jd.scheduler.JdReservation;
import org.apache.uima.ducc.transport.event.cli.ReservationRequestProperties;
import org.apache.uima.ducc.transport.event.cli.ReservationSpecificationProperties;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.DuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccCompletionType;
import org.apache.uima.ducc.transport.event.common.IDuccSchedulingInfo;
import org.apache.uima.ducc.transport.event.common.IDuccState;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IRationale;
import org.apache.uima.ducc.transport.event.common.IResourceState;
import org.apache.uima.ducc.transport.event.common.JdReservationBean;
import org.apache.uima.ducc.transport.event.common.Rationale;

public class JdScheduler {
    private static DuccLogger logger = new DuccLogger(JdScheduler.class);
    private static DuccId jobid = null;
    private static ReservationFactory reservationFactory = ReservationFactory.getInstance();
    private static JdScheduler instance = new JdScheduler();
    private static OrchestratorCommonArea orchestratorCommonArea = OrchestratorCommonArea.getInstance();
    private IDuccHead dh = DuccHead.getInstance();
    private ConcurrentHashMap<DuccId, JdReservation> map = new ConcurrentHashMap();
    private AtomicBoolean autoManage = new AtomicBoolean(true);
    private AtomicBoolean requestPending = new AtomicBoolean(false);
    private AtomicBoolean changes = new AtomicBoolean(false);
    private AtomicBoolean resumeAnnounced = new AtomicBoolean(true);
    private AtomicBoolean suspendAnnounced = new AtomicBoolean(false);

    public static JdScheduler getInstance() {
        return instance;
    }

    public void setAutomanage() {
        this.autoManage.set(true);
    }

    public void resetAutomanage() {
        this.autoManage.set(false);
    }

    public void ckpt() {
        String location = "ckpt";
        if (this.changes.get()) {
            this.changes.set(false);
            try {
                DuccWorkMap dwm = OrchestratorCommonArea.getInstance().getWorkMap();
                for (Map.Entry<DuccId, JdReservation> entry : this.map.entrySet()) {
                    DuccId reservationIdentity = entry.getKey();
                    IDuccWork dw = dwm.findDuccWork(reservationIdentity);
                    if (!(dw instanceof IDuccWorkReservation)) continue;
                    IDuccWorkReservation dwr = (IDuccWorkReservation)dw;
                    List<JdReservationBean> jdReservationBeanList = this.getJdReservationBeanList(reservationIdentity);
                    dwr.setJdReservationBeanList(jdReservationBeanList);
                    if (jdReservationBeanList != null) {
                        logger.debug(location, reservationIdentity, new Object[]{"size: " + jdReservationBeanList.size()});
                        continue;
                    }
                    logger.debug(location, reservationIdentity, new Object[]{"size: " + null});
                }
            }
            catch (Exception e) {
                logger.error(location, jobid, (Throwable)e, new Object[0]);
            }
            OrchestratorCheckpoint.getInstance().saveState();
        }
    }

    public void restore() {
        String location = "restore";
        try {
            DuccWorkMap dwm = OrchestratorCommonArea.getInstance().getWorkMap();
            for (Map.Entry entry : dwm.getMap().entrySet()) {
                IDuccWorkReservation dwr;
                List jdReservationBeanList;
                IDuccWork dw = (IDuccWork)entry.getValue();
                if (!(dw instanceof IDuccWorkReservation) || (jdReservationBeanList = (dwr = (IDuccWorkReservation)dw).getJdReservationBeanList()) == null) continue;
                this.setJdReservationBeanList(jdReservationBeanList);
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    public boolean isMinimalAllocateRequirementMet() {
        String location = "isMinimalAllocateRequirementMet";
        boolean retVal = false;
        StringBuffer sb = new StringBuffer();
        long minSlices = this.getReservationSlicesMinimum();
        long resCount = this.getReservationCount();
        sb.append("minSlices=" + minSlices);
        sb.append(" ");
        sb.append("resCount=" + resCount);
        String text = sb.toString();
        logger.debug(location, jobid, new Object[]{text});
        if (minSlices == 0L) {
            retVal = true;
        } else if (resCount > 0L) {
            retVal = true;
        }
        return retVal;
    }

    private long getReservationSlicesMinimum() {
        JdHostProperties jdHostProperties = new JdHostProperties();
        return this.getSlicesReserveDesired(jdHostProperties);
    }

    private int getReservationCount() {
        int count = 0;
        for (Map.Entry<DuccId, JdReservation> entry : this.map.entrySet()) {
            JdReservation jdReservation = entry.getValue();
            switch (jdReservation.getReservationState()) {
                case Assigned: {
                    ++count;
                    break;
                }
            }
        }
        return count;
    }

    private List<JdReservation> getJdReservationsByName(String name) {
        ArrayList<JdReservation> retVal;
        block3: {
            String location = "getJdReservationByName";
            retVal = new ArrayList<JdReservation>();
            try {
                if (name == null) break block3;
                for (Map.Entry<DuccId, JdReservation> entry : this.map.entrySet()) {
                    String host = entry.getValue().getHost();
                    if (!host.equals(name)) continue;
                    retVal.add(entry.getValue());
                    break;
                }
            }
            catch (Exception e) {
                logger.error(location, jobid, (Throwable)e, new Object[0]);
            }
        }
        return retVal;
    }

    private void cancelReservation(JdReservation jdReservation, String reason) {
        String location = "cancelReservation";
        try {
            DuccId reservationIdentity = jdReservation.getDuccId();
            DuccWorkMap workMap = orchestratorCommonArea.getWorkMap();
            String id = "" + reservationIdentity.getFriendly();
            DuccWorkReservation duccWorkReservation = (DuccWorkReservation)WorkMapHelper.findDuccWork(workMap, IDuccTypes.DuccType.Reservation, id, this, location);
            switch (duccWorkReservation.getReservationState()) {
                case Completed: {
                    break;
                }
                default: {
                    JdHostProperties jdHostProperties = new JdHostProperties();
                    duccWorkReservation.getStandardInfo().setCancelUser(jdHostProperties.getHostUser());
                    duccWorkReservation.getStandardInfo().setDateOfCompletion(TimeStamp.getCurrentMillis());
                    duccWorkReservation.stateChange(IDuccState.ReservationState.Completed);
                    duccWorkReservation.complete(IDuccCompletionType.ReservationCompletionType.CanceledBySystem);
                    Rationale rationale = new Rationale(reason);
                    duccWorkReservation.setCompletionRationale((IRationale)rationale);
                    OrchestratorCheckpoint.getInstance().saveState();
                    logger.warn(location, reservationIdentity, new Object[]{reason});
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private void cancelJobs(JdReservation jdReservation, String reason) {
        String location = "cancelJobs";
        try {
            ConcurrentHashMap map = jdReservation.getMap();
            for (Map.Entry entry : map.entrySet()) {
                DuccId jobIdentity = (DuccId)entry.getKey();
                DuccWorkMap workMap = orchestratorCommonArea.getWorkMap();
                String id = "" + jobIdentity.getFriendly();
                DuccWorkJob duccWorkJob = (DuccWorkJob)WorkMapHelper.findDuccWork(workMap, IDuccTypes.DuccType.Job, id, this, location);
                Rationale rationale = new Rationale(reason.toString());
                IDuccCompletionType.JobCompletionType jobCompletionType = IDuccCompletionType.JobCompletionType.CanceledBySystem;
                StateManager stateManager = StateManager.getInstance();
                stateManager.jobTerminate((IDuccWorkJob)duccWorkJob, jobCompletionType, (IRationale)rationale, IResourceState.ProcessDeallocationType.JobCanceled);
                OrchestratorCheckpoint.getInstance().saveState();
                logger.warn(location, jobIdentity, new Object[]{reason});
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private void handleDownNode(JdReservation jdReservation) {
        String location = "handleDownNode";
        try {
            if (jdReservation != null) {
                String host = jdReservation.getHost();
                String text = "job driver node down: " + host;
                this.cancelReservation(jdReservation, text);
                this.cancelJobs(jdReservation, text);
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private void monitor() {
        String location = "monitor";
        try {
            Map qMap = DbQuery.getInstance().getMapMachines();
            for (Map.Entry entry : qMap.entrySet()) {
                List<JdReservation> list;
                String name = ((IDbMachine)entry.getValue()).getName();
                Boolean responsive = ((IDbMachine)entry.getValue()).getResponsive();
                String text = "name:" + name + " responsive:" + responsive;
                logger.debug(location, jobid, new Object[]{text});
                if (responsive.booleanValue() || (list = this.getJdReservationsByName(name)) == null) continue;
                for (JdReservation jdReservation : list) {
                    this.handleDownNode(jdReservation);
                }
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private void resume() {
        String location = "resume";
        if (!this.resumeAnnounced.get()) {
            logger.warn(location, jobid, new Object[]{"operations resumed - master mode"});
            this.resumeAnnounced.set(true);
            this.suspendAnnounced.set(false);
        }
    }

    private void suspend() {
        String location = "suspend";
        if (!this.suspendAnnounced.get()) {
            logger.warn(location, jobid, new Object[]{"operations suspended - backup mode"});
            this.suspendAnnounced.set(true);
            this.resumeAnnounced.set(false);
        }
    }

    public void handle(IDuccWorkMap dwm) {
        String location = "handle";
        try {
            if (this.dh.is_ducc_head_virtual_master()) {
                this.resume();
                this.monitor();
                if (dwm != null) {
                    JdHostProperties jdHostProperties = new JdHostProperties();
                    this.resourceAccounting(dwm, jdHostProperties);
                    this.resourceAdjustment(dwm, jdHostProperties);
                    this.ckpt();
                } else {
                    logger.debug(location, jobid, new Object[]{"dwm: null"});
                }
            } else {
                this.suspend();
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private void resourceAccounting(IDuccWorkMap dwm, JdHostProperties jdHostProperties) {
        String location = "resourceAccounting";
        String jdHostClass = jdHostProperties.getHostClass();
        boolean pendingFlag = false;
        if (jdHostClass != null) {
            HashSet known = new HashSet();
            known.addAll(this.map.keySet());
            for (Map.Entry entry : dwm.getMap().entrySet()) {
                String schedulingClass;
                IDuccWork dw = (IDuccWork)entry.getValue();
                if (!(dw instanceof IDuccWorkReservation)) continue;
                IDuccWorkReservation dwr = (IDuccWorkReservation)dw;
                IDuccSchedulingInfo schedulingInfo = dwr.getSchedulingInfo();
                if (schedulingInfo != null && (schedulingClass = schedulingInfo.getSchedulingClass()) != null && schedulingClass.equals(jdHostClass)) {
                    IDuccState.ReservationState reservationState = dwr.getReservationState();
                    switch (reservationState) {
                        case Assigned: {
                            this.reservationUp(dwr, jdHostProperties);
                            break;
                        }
                        case Completed: {
                            this.reservationDown(dwr);
                            break;
                        }
                        case Received: 
                        case Undefined: {
                            this.reservationOther(dwr, jdHostProperties);
                            break;
                        }
                        case WaitingForResources: {
                            pendingFlag = true;
                            break;
                        }
                        default: {
                            this.reservationOther(dwr, jdHostProperties);
                        }
                    }
                }
                known.remove(entry.getKey());
            }
            for (DuccId reservationIdentity : known) {
                this.reservationVanished(reservationIdentity);
            }
        }
        if (pendingFlag) {
            this.requestPending.set(true);
        } else {
            this.requestPending.set(false);
        }
        logger.trace(location, jobid, new Object[]{"total: " + this.countReservationsTotal() + " up: " + this.countReservationsUp()});
    }

    private long getSlicesReserveDesired(JdHostProperties jdHostProperties) {
        long slicesReserveDesired = JdHelper.getSlicesReserve(jdHostProperties);
        return slicesReserveDesired;
    }

    private long getSlicesReserveActual() {
        long slicesReserveActual = this.countSlicesAvailable();
        return slicesReserveActual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReservationDivestable(IDuccWorkMap dwm, JdHostProperties jdHostProperties) {
        boolean retVal = false;
        long slicesReserveDesired = this.getSlicesReserveDesired(jdHostProperties);
        long slicesReserveActual = this.getSlicesReserveActual();
        if (this.map.size() > 1) {
            JdScheduler jdScheduler = this;
            synchronized (jdScheduler) {
                for (Map.Entry<DuccId, JdReservation> entry : this.map.entrySet()) {
                    long slicesToRelease;
                    long slicesReserveAfterRelease;
                    JdReservation jdReservation = entry.getValue();
                    if (!jdReservation.isEmpty() || (slicesReserveAfterRelease = slicesReserveActual - (slicesToRelease = jdReservation.getSlicesTotal().longValue())) <= slicesReserveDesired) continue;
                    retVal = true;
                    break;
                }
            }
        }
        return retVal;
    }

    private void resourceAdjustment(IDuccWorkMap dwm, JdHostProperties jdHostProperties) {
        String location = "resourceAdjustment";
        if (this.autoManage.get()) {
            long slicesReserveDesired = this.getSlicesReserveDesired(jdHostProperties);
            long slicesReserveActual = this.getSlicesReserveActual();
            logger.debug(location, jobid, new Object[]{"actual: " + slicesReserveActual + " desired: " + slicesReserveDesired});
            if (slicesReserveActual < slicesReserveDesired) {
                if (this.requestPending.get()) {
                    this.reservationPending(dwm, jdHostProperties);
                } else {
                    this.reservationAcquire(dwm, jdHostProperties);
                }
            } else if (this.isReservationDivestable(dwm, jdHostProperties)) {
                while (this.isReservationDivestable(dwm, jdHostProperties)) {
                    this.reservationDivest(dwm, jdHostProperties);
                }
            } else {
                this.reservationNoChange(dwm, jdHostProperties);
            }
        } else {
            logger.debug(location, jobid, new Object[]{"automanage: " + this.autoManage.get()});
        }
    }

    private void reservationPending(IDuccWorkMap dwm, JdHostProperties jdHostProperties) {
        String location = "reservationPending";
        long slicesReserveDesired = this.getSlicesReserveDesired(jdHostProperties);
        long slicesReserveActual = this.getSlicesReserveActual();
        logger.debug(location, jobid, new Object[]{"actual: " + slicesReserveActual + " desired: " + slicesReserveDesired});
    }

    private void reservationAcquire(IDuccWorkMap dwm, JdHostProperties jdHostProperties) {
        String location = "reservationAcquire";
        ReservationRequestProperties reservationRequestProperties = new ReservationRequestProperties();
        String key = ReservationSpecificationProperties.key_scheduling_class;
        String value = jdHostProperties.getHostClass();
        reservationRequestProperties.setProperty(key, value);
        key = ReservationSpecificationProperties.key_memory_size;
        value = jdHostProperties.getHostMemorySize();
        reservationRequestProperties.setProperty(key, value);
        key = ReservationSpecificationProperties.key_user;
        value = jdHostProperties.getHostUser();
        reservationRequestProperties.setProperty(key, value);
        key = ReservationSpecificationProperties.key_description;
        value = jdHostProperties.getHostDescription();
        reservationRequestProperties.setProperty(key, value);
        DuccWorkReservation dwr = reservationFactory.create(reservationRequestProperties);
        dwr.setJdReservation();
        DuccWorkMap workMap = (DuccWorkMap)dwm;
        WorkMapHelper.addDuccWork(workMap, (IDuccWork)dwr, this, location);
        dwr.stateChange(IDuccState.ReservationState.Received);
        OrchestratorCheckpoint.getInstance().saveState();
        dwr.stateChange(IDuccState.ReservationState.WaitingForResources);
        OrchestratorCheckpoint.getInstance().saveState();
        long slicesReserveDesired = this.getSlicesReserveDesired(jdHostProperties);
        long slicesReserveActual = this.getSlicesReserveActual();
        DuccId reservationIdentity = dwr.getDuccId();
        logger.info(location, reservationIdentity, new Object[]{"actual: " + slicesReserveActual + " desired: " + slicesReserveDesired});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reservationDivest(IDuccWorkMap dwm, JdHostProperties jdHostProperties) {
        IDuccWork dw;
        String location = "reservationDivest";
        DuccId reservationIdentity = null;
        JdScheduler jdScheduler = this;
        synchronized (jdScheduler) {
            for (Map.Entry<DuccId, JdReservation> entry : this.map.entrySet()) {
                JdReservation jdReservation = entry.getValue();
                if (jdReservation.isEmpty()) {
                    reservationIdentity = entry.getKey();
                    this.map.remove(reservationIdentity);
                    break;
                }
                jdReservation = null;
            }
        }
        if (reservationIdentity != null && (dw = dwm.findDuccWork(reservationIdentity)) != null) {
            IDuccWorkReservation dwr = (IDuccWorkReservation)dw;
            dwr.stateChange(IDuccState.ReservationState.Completed);
            dwr.setCompletionType(IDuccCompletionType.ReservationCompletionType.CanceledBySystem);
            dwr.setCompletionRationale((IRationale)new Rationale("excess capacity"));
            OrchestratorCheckpoint.getInstance().saveState();
        }
        long slicesReserveDesired = this.getSlicesReserveDesired(jdHostProperties);
        long slicesReserveActual = this.getSlicesReserveActual();
        logger.info(location, reservationIdentity, new Object[]{"actual: " + slicesReserveActual + " desired: " + slicesReserveDesired});
    }

    private void reservationNoChange(IDuccWorkMap dwm, JdHostProperties jdHostProperties) {
        String location = "reservationNoChange";
        long slicesReserveDesired = this.getSlicesReserveDesired(jdHostProperties);
        long slicesReserveActual = this.getSlicesReserveActual();
        logger.trace(location, jobid, new Object[]{"actual: " + slicesReserveActual + " desired: " + slicesReserveDesired});
    }

    private void setJdReservationBeanList(List<JdReservationBean> jdReservationBeanList) {
        if (jdReservationBeanList != null) {
            for (JdReservationBean entry : jdReservationBeanList) {
                JdReservation jdReservation = (JdReservation)entry;
                DuccId reservationIdentity = jdReservation.getDuccId();
                this.map.put(reservationIdentity, jdReservation);
            }
        }
    }

    public List<JdReservationBean> getJdReservationBeanList(DuccId reservationIdentity) {
        String location = "getJdReservationBeanList";
        ArrayList<JdReservationBean> jdReservationBeanList = new ArrayList<JdReservationBean>();
        for (Map.Entry<DuccId, JdReservation> entry : this.map.entrySet()) {
            JdReservation jdReservation = entry.getValue();
            if (!reservationIdentity.equals((Object)jdReservation.getDuccId())) continue;
            jdReservationBeanList.add(jdReservation);
            logger.trace(location, reservationIdentity, new Object[]{jdReservationBeanList.size()});
        }
        return jdReservationBeanList;
    }

    public int countReservationsTotal() {
        int count = this.map.size();
        return count;
    }

    public int countReservationsUp() {
        int count = 0;
        for (Map.Entry<DuccId, JdReservation> entry : this.map.entrySet()) {
            JdReservation jdReservation = entry.getValue();
            if (!jdReservation.isUp()) continue;
            ++count;
        }
        return count;
    }

    private void reservationUp(IDuccWorkReservation dwr, JdHostProperties jdHostProperties) {
        String location = "reservationUp";
        DuccId reservationIdentity = dwr.getDuccId();
        JdReservation jdReservation = null;
        SizeBytes reservationSize = JdHelper.getReservationSize(dwr);
        SizeBytes sliceSize = JdHelper.getSliceSize(jdHostProperties);
        jdReservation = this.map.get(reservationIdentity);
        if (jdReservation == null) {
            jdReservation = new JdReservation(dwr, reservationSize, sliceSize);
            this.map.putIfAbsent(reservationIdentity, jdReservation);
        } else if (!jdReservation.isUp()) {
            jdReservation = new JdReservation(dwr, reservationSize, sliceSize);
            this.map.putIfAbsent(reservationIdentity, jdReservation);
        }
        jdReservation = this.map.get(reservationIdentity);
        if (jdReservation != null) {
            logger.debug(location, reservationIdentity, new Object[]{"host: " + jdReservation.getHost()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reservationDown(IDuccWorkReservation dwr) {
        String location = "reservationDown";
        DuccId reservationIdentity = dwr.getDuccId();
        JdReservation jdReservation = null;
        ArrayList<JdReservation> list = new ArrayList<JdReservation>();
        JdScheduler jdScheduler = this;
        synchronized (jdScheduler) {
            jdReservation = this.map.get(reservationIdentity);
            if (jdReservation != null) {
                this.map.remove(reservationIdentity);
                list.add(jdReservation);
            }
        }
        if (list.size() > 0) {
            logger.info(location, reservationIdentity, new Object[]{list.size()});
            this.defunct(list);
        }
    }

    private void reservationOther(IDuccWorkReservation dwr, JdHostProperties jdHostProperties) {
        String location = " reservationOther";
        DuccId reservationIdentity = dwr.getDuccId();
        JdReservation jdReservation = null;
        SizeBytes reservationSize = JdHelper.getReservationSize(dwr);
        SizeBytes sliceSize = JdHelper.getSliceSize(jdHostProperties);
        jdReservation = this.map.get(reservationIdentity);
        if (jdReservation == null) {
            jdReservation = new JdReservation(dwr, reservationSize, sliceSize);
            this.map.putIfAbsent(reservationIdentity, jdReservation);
        }
        jdReservation = this.map.get(reservationIdentity);
        logger.trace(location, reservationIdentity, new Object[]{"total: " + this.countReservationsTotal() + " up: " + this.countReservationsUp()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reservationVanished(DuccId reservationIdentity) {
        String location = "reservationVanished";
        ArrayList<JdReservation> list = new ArrayList<JdReservation>();
        JdScheduler jdScheduler = this;
        synchronized (jdScheduler) {
            JdReservation jdReservation = this.map.get(reservationIdentity);
            if (jdReservation != null) {
                jdReservation = this.map.remove(reservationIdentity);
                list.add(jdReservation);
            }
        }
        if (list.size() > 0) {
            DuccId duccId = reservationIdentity;
            logger.info(location, duccId, new Object[]{list.size()});
            this.defunct(list);
        }
    }

    private void defunct(List<JdReservation> list) {
        if (list != null && !list.isEmpty()) {
            for (JdReservation jdReservation : list) {
                this.defunct(jdReservation);
            }
        }
    }

    private void defunct(JdReservation jdReservation) {
        String location = "defunct";
        if (jdReservation != null) {
            DuccId reservationIdentity = jdReservation.getDuccId();
            logger.debug(location, reservationIdentity, new Object[]{"host: " + jdReservation.getHost()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeIdentity allocate(DuccId jobIdentity, DuccId driverIdentity) {
        String location = "allocate";
        NodeIdentity nodeIdentity = null;
        if (jobIdentity != null) {
            String host = null;
            JdScheduler jdScheduler = this;
            synchronized (jdScheduler) {
                for (Map.Entry<DuccId, JdReservation> entry : this.map.entrySet()) {
                    JdReservation jdReservation = entry.getValue();
                    host = jdReservation.getHost();
                    logger.debug(location, jobIdentity, new Object[]{"host: " + host + " job: " + jobIdentity});
                    nodeIdentity = jdReservation.allocate(jobIdentity, driverIdentity);
                    if (nodeIdentity == null) continue;
                    host = nodeIdentity.getCanonicalName();
                    this.changes.set(true);
                    break;
                }
            }
            if (nodeIdentity != null) {
                logger.debug(location, jobIdentity, new Object[]{"host: " + host + " job: " + jobIdentity});
            }
        }
        return nodeIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocate(DuccId jobIdentity, DuccId driverIdentity) {
        String location = "deallocate";
        NodeIdentity nodeIdentity = null;
        if (jobIdentity != null) {
            String host = null;
            logger.debug(location, jobIdentity, new Object[]{"map size: " + this.map.size()});
            JdScheduler jdScheduler = this;
            synchronized (jdScheduler) {
                for (Map.Entry<DuccId, JdReservation> entry : this.map.entrySet()) {
                    JdReservation jdReservation = entry.getValue();
                    host = jdReservation.getHost();
                    logger.debug(location, jobIdentity, new Object[]{"host: " + host + " job: " + jobIdentity});
                    nodeIdentity = jdReservation.deallocate(jobIdentity, driverIdentity);
                    if (nodeIdentity == null) continue;
                    host = nodeIdentity.getCanonicalName();
                    this.changes.set(true);
                    break;
                }
            }
            if (nodeIdentity != null) {
                logger.debug(location, jobIdentity, new Object[]{"host: " + host + " job: " + jobIdentity});
            }
        }
    }

    public int countSlicesTotal(DuccId reservationIdentity) {
        String location = "countSlicesTotal";
        int count = 0;
        JdReservation jdReservation = this.map.get(reservationIdentity);
        if (jdReservation != null) {
            count = (int)((long)count + jdReservation.getSlicesTotal());
        }
        logger.trace(location, reservationIdentity, new Object[]{count});
        return count;
    }

    public int countSlicesInuse(DuccId reservationIdentity) {
        String location = "countSlicesInuse";
        int count = 0;
        JdReservation jdReservation = this.map.get(reservationIdentity);
        if (jdReservation != null) {
            count = (int)((long)count + jdReservation.getSlicesInuse());
        }
        logger.trace(location, reservationIdentity, new Object[]{count});
        return count;
    }

    public int countSlicesAvailable(DuccId reservationIdentity) {
        String location = "countSlicesAvailable";
        int count = 0;
        JdReservation jdReservation = this.map.get(reservationIdentity);
        if (jdReservation != null) {
            count = (int)((long)count + jdReservation.getSlicesAvailable());
        }
        logger.trace(location, reservationIdentity, new Object[]{count});
        return count;
    }

    public int countSlicesTotal() {
        String location = "countSlicesTotal";
        int count = 0;
        for (Map.Entry<DuccId, JdReservation> entry : this.map.entrySet()) {
            JdReservation jdReservation = entry.getValue();
            count = (int)((long)count + jdReservation.getSlicesTotal());
        }
        logger.trace(location, jobid, new Object[]{count});
        return count;
    }

    public int countSlicesInuse() {
        String location = "countSlicesInuse";
        int count = 0;
        for (Map.Entry<DuccId, JdReservation> entry : this.map.entrySet()) {
            JdReservation jdReservation = entry.getValue();
            count = (int)((long)count + jdReservation.getSlicesInuse());
        }
        logger.trace(location, jobid, new Object[]{count});
        return count;
    }

    public int countSlicesAvailable() {
        String location = "countSlicesAvailable";
        int count = 0;
        for (Map.Entry<DuccId, JdReservation> entry : this.map.entrySet()) {
            JdReservation jdReservation = entry.getValue();
            count = (int)((long)count + jdReservation.getSlicesAvailable());
        }
        logger.trace(location, jobid, new Object[]{count});
        return count;
    }
}

