/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.database;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.uima.ducc.common.head.IDuccHead;
import org.apache.uima.ducc.common.persistence.or.ITypedProperties;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.database.DbDuccWorks;
import org.apache.uima.ducc.orchestrator.DuccHead;

public class OrDbDuccWorks
extends DbDuccWorks {
    private static DuccLogger logger = DuccLogger.getLogger(OrDbDuccWorks.class);
    private static DuccId jobid = null;
    private IDuccHead dh = DuccHead.getInstance();
    private AtomicBoolean resumeAnnounced = new AtomicBoolean(true);
    private AtomicBoolean suspendAnnounced = new AtomicBoolean(false);

    public OrDbDuccWorks() throws Exception {
        super(logger);
    }

    private void resume() {
        String location = "resume";
        if (!this.resumeAnnounced.get()) {
            logger.warn(location, jobid, new Object[]{"operations resumed - master mode"});
            this.resumeAnnounced.set(true);
            this.suspendAnnounced.set(false);
        }
    }

    private void suspend() {
        String location = "suspend";
        if (!this.suspendAnnounced.get()) {
            logger.warn(location, jobid, new Object[]{"operations suspended - backup mode"});
            this.suspendAnnounced.set(true);
            this.resumeAnnounced.set(false);
        }
    }

    public void dbInit() throws Exception {
        if (this.dh.is_ducc_head_virtual_master()) {
            this.resume();
            super.dbInit();
        } else {
            this.suspend();
        }
    }

    public void upsertSpecification(String type, long id, ITypedProperties properties) throws Exception {
        if (this.dh.is_ducc_head_virtual_master()) {
            this.resume();
            super.upsertSpecification(type, id, properties);
        } else {
            this.suspend();
        }
    }
}

