# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# ~~~
# tvm_ffi_add_cxx_warning(target_name)
# Apply a consistent set of warning flags (or placeholders) depending on the active compiler family.
# Parameters:
#   target_name: CMake target to modify
# ~~~
function (tvm_ffi_add_cxx_warning target_name)
  # GNU, Clang, or AppleClang
  if (CMAKE_CXX_COMPILER_ID MATCHES "GNU|Clang|AppleClang")
    target_compile_options(
      ${target_name} PRIVATE "-Werror" "-Wall" "-Wextra" "-Wpedantic" "-Wno-unused-parameter"
    )
    return()
  endif ()
  # MSVC
  if (MSVC)
    # target_compile_options(${target_name} PRIVATE "/W4" "/WX")
    return()
  endif ()
  message(FATAL_ERROR "Unsupported compiler: ${CMAKE_CXX_COMPILER_ID}")
endfunction ()
