/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.ConnectiveStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.NotStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TraversalFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WhereTraversalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStepPlaceholder;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.IdentityRemovalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.IncidentToAdjacentStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.PropertyType;

public final class AdjacentToIncidentStrategy
extends AbstractTraversalStrategy<TraversalStrategy.OptimizationStrategy>
implements TraversalStrategy.OptimizationStrategy {
    private static final AdjacentToIncidentStrategy INSTANCE = new AdjacentToIncidentStrategy();
    private static final Set<Class<? extends TraversalStrategy.OptimizationStrategy>> PRIORS = new HashSet<Class>(Arrays.asList(IdentityRemovalStrategy.class, IncidentToAdjacentStrategy.class));

    private AdjacentToIncidentStrategy() {
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        List<Step> steps = traversal.getSteps();
        int size = steps.size() - 1;
        Step prev = null;
        for (int i = 0; i <= size; ++i) {
            Step curr = steps.get(i);
            if (i == size && AdjacentToIncidentStrategy.isOptimizable(curr)) {
                TraversalParent parent = curr.getTraversal().getParent();
                if (parent instanceof NotStep || parent instanceof TraversalFilterStep || parent instanceof WhereTraversalStep || parent instanceof ConnectiveStep) {
                    AdjacentToIncidentStrategy.optimizeStep(traversal, curr);
                }
            } else if (AdjacentToIncidentStrategy.isOptimizable(prev) && curr instanceof CountGlobalStep) {
                AdjacentToIncidentStrategy.optimizeStep(traversal, prev);
            }
            if (curr instanceof RangeGlobalStep) continue;
            prev = curr;
        }
    }

    @Override
    public Set<Class<? extends TraversalStrategy.OptimizationStrategy>> applyPrior() {
        return PRIORS;
    }

    private static boolean isOptimizable(Step step) {
        return (step instanceof VertexStepContract && ((VertexStepContract)step).returnsVertex() || step instanceof PropertiesStep && PropertyType.VALUE.equals((Object)((PropertiesStep)step).getReturnType())) && (step.getTraversal().getEndStep().getLabels().isEmpty() || step.getNextStep() instanceof CountGlobalStep);
    }

    private static void optimizeStep(Traversal.Admin traversal, Step step) {
        FlatMapStep newStep;
        if (step instanceof VertexStepContract) {
            VertexStepContract vs = (VertexStepContract)step;
            newStep = new VertexStepPlaceholder<Edge>(traversal, Edge.class, vs.getDirection(), vs.getEdgeLabelsAsGValues());
        } else if (step instanceof PropertiesStep) {
            PropertiesStep ps = (PropertiesStep)step;
            newStep = new PropertiesStep(traversal, PropertyType.PROPERTY, ps.getPropertyKeys());
        } else {
            return;
        }
        TraversalHelper.replaceStep(step, newStep, traversal);
    }

    public static AdjacentToIncidentStrategy instance() {
        return INSTANCE;
    }
}

