/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.impl;

import com.netflix.spectator.api.Id;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class IdMapper
implements BiFunction<Id, Set<String>, Map<String, String>> {
    private final Function<String, String> fixTagString;

    public IdMapper(Function<String, String> fixTagString) {
        this.fixTagString = fixTagString;
    }

    @Override
    public Map<String, String> apply(Id id, Set<String> keys) {
        int size = id.size();
        HashMap<String, String> tags = new HashMap<String, String>(keys.size());
        for (int i = 1; i < size; ++i) {
            String k = this.fixTagString.apply(id.getKey(i));
            if (!keys.contains(k)) continue;
            String v = this.fixTagString.apply(id.getValue(i));
            tags.put(k, v);
        }
        if (keys.contains("name")) {
            String name = this.fixTagString.apply(id.name());
            tags.put("name", name);
        }
        return tags;
    }
}

