/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.authorization.generator;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.oidc.profile.keycloak.KeycloakOidcProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakRolesAuthorizationGenerator
implements AuthorizationGenerator {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(KeycloakRolesAuthorizationGenerator.class);
    private String clientId;

    public KeycloakRolesAuthorizationGenerator() {
    }

    public KeycloakRolesAuthorizationGenerator(String clientId) {
        this.clientId = clientId;
    }

    public Optional<UserProfile> generate(CallContext ctx, UserProfile profile) {
        if (profile instanceof KeycloakOidcProfile) {
            try {
                List clientRolesJsonArray;
                Map clientRolesJsonObject;
                Map resourceAccess;
                List realmRolesJsonArray;
                SignedJWT jwt = SignedJWT.parse((String)((KeycloakOidcProfile)profile).getAccessToken().getValue());
                JWTClaimsSet jwtClaimsSet = jwt.getJWTClaimsSet();
                Map realmRolesJsonObject = jwtClaimsSet.getJSONObjectClaim("realm_access");
                if (realmRolesJsonObject != null && (realmRolesJsonArray = (List)realmRolesJsonObject.get("roles")) != null) {
                    realmRolesJsonArray.forEach(role -> profile.addRole(role));
                }
                if (this.clientId != null && (resourceAccess = jwtClaimsSet.getJSONObjectClaim("resource_access")) != null && (clientRolesJsonObject = (Map)resourceAccess.get(this.clientId)) != null && (clientRolesJsonArray = (List)clientRolesJsonObject.get("roles")) != null) {
                    clientRolesJsonArray.forEach(arg_0 -> ((UserProfile)profile).addRole(arg_0));
                }
            }
            catch (Exception e) {
                LOGGER.warn("Cannot parse Keycloak roles", (Throwable)e);
            }
        }
        return Optional.of(profile);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }
}

