/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.persistence.entity.data.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;
import org.flowable.eventregistry.api.EventDefinition;
import org.flowable.eventregistry.impl.EventDefinitionQueryImpl;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntityImpl;
import org.flowable.eventregistry.impl.persistence.entity.data.AbstractEventDataManager;
import org.flowable.eventregistry.impl.persistence.entity.data.EventDefinitionDataManager;

public class MybatisEventDefinitionDataManager
extends AbstractEventDataManager<EventDefinitionEntity>
implements EventDefinitionDataManager {
    public MybatisEventDefinitionDataManager(EventRegistryEngineConfiguration eventRegistryConfiguration) {
        super(eventRegistryConfiguration);
    }

    public Class<? extends EventDefinitionEntity> getManagedEntityClass() {
        return EventDefinitionEntityImpl.class;
    }

    public EventDefinitionEntity create() {
        return new EventDefinitionEntityImpl();
    }

    @Override
    public EventDefinitionEntity findLatestEventDefinitionByKey(String eventDefinitionKey) {
        return (EventDefinitionEntity)this.getDbSqlSession().selectOne("selectLatestEventDefinitionByKey", (Object)eventDefinitionKey);
    }

    @Override
    public EventDefinitionEntity findLatestEventDefinitionByKeyAndTenantId(String eventDefinitionKey, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("eventDefinitionKey", eventDefinitionKey);
        params.put("tenantId", tenantId);
        return (EventDefinitionEntity)this.getDbSqlSession().selectOne("selectLatestEventDefinitionByKeyAndTenantId", params);
    }

    @Override
    public EventDefinitionEntity findLatestEventDefinitionByKeyAndParentDeploymentId(String eventDefinitionKey, String parentDeploymentId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("eventDefinitionKey", eventDefinitionKey);
        params.put("parentDeploymentId", parentDeploymentId);
        return (EventDefinitionEntity)this.getDbSqlSession().selectOne("selectEventDefinitionByKeyAndParentDeploymentId", params);
    }

    @Override
    public EventDefinitionEntity findLatestEventDefinitionByKeyParentDeploymentIdAndTenantId(String eventDefinitionKey, String parentDeploymentId, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("eventDefinitionKey", eventDefinitionKey);
        params.put("parentDeploymentId", parentDeploymentId);
        params.put("tenantId", tenantId);
        return (EventDefinitionEntity)this.getDbSqlSession().selectOne("selectEventDefinitionByKeyParentDeploymentIdAndTenantId", params);
    }

    @Override
    public void deleteEventDefinitionsByDeploymentId(String deploymentId) {
        this.getDbSqlSession().delete("deleteEventDefinitionsByDeploymentId", (Object)deploymentId, this.getManagedEntityClass());
    }

    @Override
    public List<EventDefinition> findEventDefinitionsByQueryCriteria(EventDefinitionQueryImpl eventDefinitionQuery) {
        return this.getDbSqlSession().selectList("selectEventDefinitionsByQueryCriteria", (ListQueryParameterObject)eventDefinitionQuery);
    }

    @Override
    public long findEventDefinitionCountByQueryCriteria(EventDefinitionQueryImpl eventDefinitionQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectEventDefinitionCountByQueryCriteria", (Object)eventDefinitionQuery);
    }

    @Override
    public EventDefinitionEntity findEventDefinitionByDeploymentAndKey(String deploymentId, String eventDefinitionKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("eventDefinitionKey", eventDefinitionKey);
        return (EventDefinitionEntity)this.getDbSqlSession().selectOne("selectEventDefinitionByDeploymentAndKey", parameters);
    }

    @Override
    public EventDefinitionEntity findEventDefinitionByDeploymentAndKeyAndTenantId(String deploymentId, String eventDefinitionKey, String tenantId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("eventDefinitionKey", eventDefinitionKey);
        parameters.put("tenantId", tenantId);
        return (EventDefinitionEntity)this.getDbSqlSession().selectOne("selectEventDefinitionByDeploymentAndKeyAndTenantId", parameters);
    }

    @Override
    public EventDefinitionEntity findEventDefinitionByKeyAndVersion(String eventDefinitionKey, Integer eventVersion) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("eventDefinitionKey", eventDefinitionKey);
        params.put("eventVersion", eventVersion);
        List results = this.getDbSqlSession().selectList("selectEventDefinitionsByKeyAndVersion", params);
        if (results.size() == 1) {
            return (EventDefinitionEntity)results.get(0);
        }
        if (results.size() > 1) {
            throw new FlowableException("There are " + results.size() + " event definitions with key = '" + eventDefinitionKey + "' and version = '" + eventVersion + "'.");
        }
        return null;
    }

    @Override
    public EventDefinitionEntity findEventDefinitionByKeyAndVersionAndTenantId(String eventDefinitionKey, Integer eventVersion, String tenantId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("eventDefinitionKey", eventDefinitionKey);
        params.put("eventVersion", eventVersion);
        params.put("tenantId", tenantId);
        List results = this.getDbSqlSession().selectList("selectEventDefinitionsByKeyAndVersionAndTenantId", params);
        if (results.size() == 1) {
            return (EventDefinitionEntity)results.get(0);
        }
        if (results.size() > 1) {
            throw new FlowableException("There are " + results.size() + " event definitions with key = '" + eventDefinitionKey + "' and version = '" + eventVersion + "' in tenant = '" + tenantId + "'.");
        }
        return null;
    }

    @Override
    public List<EventDefinition> findEventDefinitionsByNativeQuery(Map<String, Object> parameterMap) {
        return this.getDbSqlSession().selectListWithRawParameter("selectEventDefinitionByNativeQuery", parameterMap);
    }

    @Override
    public long findEventDefinitionCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectEventDefinitionCountByNativeQuery", parameterMap);
    }

    @Override
    public void updateEventDefinitionTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().directUpdate("updateEventDefinitionTenantIdForDeploymentId", params);
    }
}

