/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.pac4j.discovery.DelegatedAuthenticationDynamicDiscoveryProviderLocator;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.pac4j.core.client.IndirectClient;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageResolver;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedClientAuthenticationDynamicDiscoveryExecutionAction
extends BaseCasWebflowAction {
    private final DelegatedClientAuthenticationConfigurationContext configContext;
    private final DelegatedAuthenticationDynamicDiscoveryProviderLocator selector;

    protected Event doExecuteInternal(RequestContext requestContext) {
        String userid = requestContext.getRequestParameters().get("username");
        DelegatedAuthenticationDynamicDiscoveryProviderLocator.DynamicDiscoveryProviderRequest request = DelegatedAuthenticationDynamicDiscoveryProviderLocator.DynamicDiscoveryProviderRequest.builder().userId(userid).build();
        Optional client = (Optional)FunctionUtils.doUnchecked(() -> this.selector.locate(request));
        if (client.isEmpty()) {
            MessageResolver msg = new MessageBuilder().error().code("screen.pac4j.discovery.unknownclient").build();
            requestContext.getMessageContext().addMessage(msg);
            requestContext.getRequestScope().put("username", (Object)userid);
            return this.error();
        }
        return (Event)FunctionUtils.doUnchecked(() -> {
            this.configContext.getDelegatedClientIdentityProvidersProducer().produce(requestContext, (IndirectClient)client.get()).ifPresent(cfg -> requestContext.getRequestScope().put("delegatedAuthProviderRedirectUrl", (Object)cfg.getRedirectUrl()));
            return new Event((Object)this, "redirect", (AttributeMap)new LocalAttributeMap("client", client.get()));
        });
    }

    @Generated
    public DelegatedClientAuthenticationDynamicDiscoveryExecutionAction(DelegatedClientAuthenticationConfigurationContext configContext, DelegatedAuthenticationDynamicDiscoveryProviderLocator selector) {
        this.configContext = configContext;
        this.selector = selector;
    }
}

