/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.kafka.common.KafkaException;

public class ChildFirstClassLoader
extends URLClassLoader {
    public ChildFirstClassLoader(String classPath, ClassLoader parent) {
        super(ChildFirstClassLoader.classpathToURLs(classPath), parent);
    }

    private static URL[] classpathToURLs(String classPath) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : classPath.split(File.pathSeparator)) {
            if (path == null || path.trim().isEmpty()) continue;
            File file = new File(path);
            try {
                if (path.endsWith("/*")) {
                    File[] files;
                    File parent = new File(new File(file.getCanonicalPath()).getParent());
                    if (!parent.isDirectory() || (files = parent.listFiles((dir, name) -> {
                        String lower = name.toLowerCase(Locale.ROOT);
                        return lower.endsWith(".jar") || lower.endsWith(".zip");
                    })) == null) continue;
                    for (File jarFile : files) {
                        urls.add(jarFile.getCanonicalFile().toURI().toURL());
                    }
                    continue;
                }
                if (!file.exists()) continue;
                urls.add(file.getCanonicalFile().toURI().toURL());
            }
            catch (IOException e) {
                throw new KafkaException(e);
            }
        }
        return urls.toArray(new URL[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = super.loadClass(name, false);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = super.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        final Enumeration<URL> urls1 = this.findResources(name);
        final Enumeration<URL> urls2 = this.getParent() != null ? this.getParent().getResources(name) : null;
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return urls1 != null && urls1.hasMoreElements() || urls2 != null && urls2.hasMoreElements();
            }

            @Override
            public URL nextElement() {
                if (urls1 != null && urls1.hasMoreElements()) {
                    return (URL)urls1.nextElement();
                }
                if (urls2 != null && urls2.hasMoreElements()) {
                    return (URL)urls2.nextElement();
                }
                throw new NoSuchElementException();
            }
        };
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

