/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yubico.core.WebAuthnCache;
import com.yubico.internal.util.JacksonCodecs;
import com.yubico.webauthn.data.ByteArray;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSessionWebAuthnCache<R>
implements WebAuthnCache<R> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSessionWebAuthnCache.class);
    private static final ObjectMapper MAPPER = JacksonCodecs.json().findAndRegisterModules();
    private final String mapName;
    private final Class<R> clazz;

    private static HttpSession retrieveSession(HttpServletRequest request) {
        HttpSession session = null;
        if (request != null) {
            session = request.getSession(true);
            LOGGER.trace("Session from web request: [{}]", (Object)session);
        } else {
            LOGGER.error("Cannot get session");
        }
        return session;
    }

    private Map<String, String> retrieveMap(HttpServletRequest request) {
        HttpSession session = WebSessionWebAuthnCache.retrieveSession(request);
        if (session != null) {
            HashMap map = (HashMap)session.getAttribute(this.mapName);
            if (map == null) {
                map = new HashMap();
                session.setAttribute(this.mapName, map);
            }
            return map;
        }
        return new HashMap<String, String>();
    }

    @Override
    public void put(HttpServletRequest request, ByteArray key, R obj) {
        String key64 = key.getBase64();
        FunctionUtils.doUnchecked(__ -> {
            String value = MAPPER.writeValueAsString(obj);
            LOGGER.trace("Put value([{}]): [{}] for key: [{}]", new Object[]{this.clazz, value, key64});
            this.retrieveMap(request).put(key64, value);
        }, (Object[])new Object[0]);
    }

    @Override
    public R getIfPresent(HttpServletRequest request, ByteArray key) {
        String key64 = key.getBase64();
        String value = this.retrieveMap(request).get(key64);
        if (value == null) {
            return null;
        }
        LOGGER.trace("GetIfPresent value([{}]): [{}] for key: [{}]", new Object[]{this.clazz, value, key64});
        return (R)FunctionUtils.doUnchecked(() -> MAPPER.readValue(value, this.clazz));
    }

    @Override
    public R get(HttpServletRequest request, ByteArray key, Function<ByteArray, ? extends R> mappingFunction) {
        String key64 = key.getBase64();
        Map<String, String> map = this.retrieveMap(request);
        return (R)FunctionUtils.doUnchecked(() -> {
            String value = this.retrieveMap(request).get(key64);
            if (value == null) {
                Object newObj = mappingFunction.apply(key);
                if (newObj != null) {
                    value = MAPPER.writeValueAsString(newObj);
                    LOGGER.trace("Save value([{}]): [{}] for key: [{}]", new Object[]{this.clazz, value, key64});
                    map.put(key64, value);
                }
                return newObj;
            }
            LOGGER.trace("Get value([{}]): [{}] for key: [{}]", new Object[]{this.clazz, value, key64});
            return MAPPER.readValue(value, this.clazz);
        });
    }

    @Override
    public void invalidate(HttpServletRequest request, ByteArray key) {
        String key64 = key.getBase64();
        LOGGER.trace("Invalidate value for key: [{}]", (Object)key64);
        this.retrieveMap(request).remove(key64);
    }

    @Generated
    public WebSessionWebAuthnCache(String mapName, Class<R> clazz) {
        this.mapName = mapName;
        this.clazz = clazz;
    }
}

